/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mods.railcraft.Translations;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeBlock;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterBlockEntity;
import mods.railcraft.world.level.block.entity.ForceTrackEmitterState;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ForceTrackEmitterBlock
extends BaseEntityBlock
implements ChargeBlock {
    public static final DyeColor DEFAULT_COLOR = DyeColor.LIGHT_BLUE;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    private static final Map<Charge, ChargeBlock.Spec> CHARGE_SPECS = ChargeBlock.Spec.make(Charge.distribution, ChargeBlock.ConnectType.BLOCK, 0.0f, new ChargeStorage.Spec(ChargeStorage.State.RECHARGEABLE, 1000, 1000, 1.0f));
    private static final MapCodec<ForceTrackEmitterBlock> CODEC = ForceTrackEmitterBlock.simpleCodec(ForceTrackEmitterBlock::new);

    public ForceTrackEmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue(COLOR, (Comparable)DEFAULT_COLOR));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, COLOR});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    public Map<Charge, ChargeBlock.Spec> getChargeSpecs(BlockState state, ServerLevel level, BlockPos pos) {
        return CHARGE_SPECS;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (super.useItemOn(itemStack, state, level, pos, player, hand, rayTraceResult).consumesAction()) {
            return ItemInteractionResult.CONSUME;
        }
        if (player.isShiftKeyDown()) {
            return ItemInteractionResult.FAIL;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty() || hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ForceTrackEmitterBlockEntity) {
            ForceTrackEmitterBlockEntity t = (ForceTrackEmitterBlockEntity)blockEntity;
            DyeColor color = DyeColor.getColor((ItemStack)heldItem);
            if (color != null && t.setColor(color)) {
                if (!player.isCreative()) {
                    player.setItemInHand(hand, ContainerTools.depleteItem(heldItem));
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }

    private ItemStack getItem(BlockState blockState) {
        ItemStack itemStack = this.asItem().getDefaultInstance();
        itemStack.set(DataComponents.BASE_COLOR, (Object)((DyeColor)blockState.getValue(COLOR)));
        return itemStack;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState) {
        return this.getItem(blockState);
    }

    public List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        return Collections.singletonList(this.getItem(blockState));
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            Charge.zapEffectProvider().throwSparks(stateIn, level, pos, rand, 10);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        this.registerNode(state, level, pos);
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        if (level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).map(ForceTrackEmitterBlockEntity::getStateInstance).map(ForceTrackEmitterState.Instance::state).filter(ForceTrackEmitterState.RETRACTED::equals).isEmpty()) {
            return state;
        }
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!state.is(oldState.getBlock())) {
            this.registerNode(state, (ServerLevel)level, pos);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos changedPos, boolean something) {
        super.neighborChanged(state, level, pos, block, changedPos, something);
        level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).ifPresent(ForceTrackEmitterBlockEntity::checkSignal);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.has(DataComponents.BASE_COLOR) && (blockEntity = level.getBlockEntity(pos)) instanceof ForceTrackEmitterBlockEntity) {
            ForceTrackEmitterBlockEntity t = (ForceTrackEmitterBlockEntity)blockEntity;
            DyeColor color = (DyeColor)itemStack.get(DataComponents.BASE_COLOR);
            if (color != null) {
                t.setColor(color);
            }
        }
        level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).ifPresent(ForceTrackEmitterBlockEntity::checkSignal);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            level.getBlockEntity(pos, (BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()).ifPresent(ForceTrackEmitterBlockEntity::clearTracks);
        }
        super.onRemove(state, level, pos, newState, moved);
        if (!state.is(newState.getBlock())) {
            this.deregisterNode((ServerLevel)level, pos);
        }
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ForceTrackEmitterBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.isClientSide() ? null : ForceTrackEmitterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)RailcraftBlockEntityTypes.FORCE_TRACK_EMITTER.get()), ForceTrackEmitterBlockEntity::serverTick);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        tooltip.add((Component)Component.translatable((String)Translations.Tips.FORCE_TRACK_EMITTER).withStyle(ChatFormatting.GRAY));
    }

    public static Direction getFacing(BlockState blockState) {
        return (Direction)blockState.getValue((Property)FACING);
    }
}

