/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.Translations;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.TicketComponent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ResolvableProfile;
import org.jetbrains.annotations.Nullable;

public class TicketItem
extends Item {
    public static final Predicate<ItemStack> FILTER = stack -> stack != null && stack.getItem() instanceof TicketItem;
    public static final int LINE_LENGTH = 32;

    public TicketItem(Item.Properties properties) {
        super(properties);
    }

    public Component getName(ItemStack stack) {
        Component name = super.getName(stack);
        String dest = TicketItem.getDestination(stack);
        if (!dest.isEmpty()) {
            String pretty_dest = dest.substring(dest.lastIndexOf("/") + 1);
            name = name.copy().append(" - " + pretty_dest);
        }
        return name;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        if (!stack.has(RailcraftDataComponents.TICKET)) {
            list.add((Component)Component.translatable((String)Translations.Tips.ROUTING_TICKET_BLANK).withStyle(ChatFormatting.GRAY));
            return;
        }
        GameProfile owner = TicketItem.getOwner(stack);
        if (owner != null) {
            list.add((Component)Component.translatable((String)Translations.Tips.ROUTING_TICKET_ISSUER).withStyle(ChatFormatting.AQUA).append(CommonComponents.SPACE).append((Component)Component.literal((String)owner.getName()).withStyle(ChatFormatting.GRAY)));
        }
        String dest = TicketItem.getDestination(stack);
        list.add((Component)Component.translatable((String)Translations.Tips.ROUTING_TICKET_DEST).withStyle(ChatFormatting.AQUA).append(CommonComponents.SPACE).append((Component)(dest.isEmpty() ? Component.translatable((String)Translations.Tips.NONE) : Component.literal((String)dest)).withStyle(ChatFormatting.GRAY)));
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public static ItemStack copyTicket(ItemStack source) {
        if (source.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (source.getItem() instanceof TicketItem) {
            ItemStack ticket = ((TicketItem)((Object)RailcraftItems.TICKET.get())).getDefaultInstance();
            if (ticket.isEmpty()) {
                return ItemStack.EMPTY;
            }
            TicketComponent ticketData = (TicketComponent)source.get(RailcraftDataComponents.TICKET);
            if (ticketData != null) {
                ticket.set(RailcraftDataComponents.TICKET, (Object)ticketData);
            }
            return ticket;
        }
        return ItemStack.EMPTY;
    }

    public static boolean setTicketData(ItemStack ticket, String dest, @Nullable GameProfile owner) {
        if (ticket.isEmpty() || !(ticket.getItem() instanceof TicketItem)) {
            return false;
        }
        if (dest.length() > 32) {
            return false;
        }
        if (owner == null) {
            return false;
        }
        ticket.set(RailcraftDataComponents.TICKET, (Object)new TicketComponent(dest, owner));
        return true;
    }

    public static String getDestination(ItemStack ticket) {
        if (ticket.isEmpty() || !(ticket.getItem() instanceof TicketItem)) {
            return "";
        }
        if (!ticket.has(RailcraftDataComponents.TICKET)) {
            return "";
        }
        TicketComponent ticketData = (TicketComponent)ticket.get(RailcraftDataComponents.TICKET);
        return ticketData.destination();
    }

    @Nullable
    public static GameProfile getOwner(ItemStack ticket) {
        if (ticket.isEmpty() || !(ticket.getItem() instanceof TicketItem)) {
            return null;
        }
        if (!ticket.has(RailcraftDataComponents.TICKET)) {
            return null;
        }
        TicketComponent ticketData = (TicketComponent)ticket.get(RailcraftDataComponents.TICKET);
        return ticketData.owner().map(ResolvableProfile::gameProfile).orElse(null);
    }
}

