/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.ClientManager;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LinkedCartsMessage(Collection<LinkedCart> linkedCarts) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LinkedCartsMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("linked_carts"));
    public static final StreamCodec<FriendlyByteBuf, LinkedCartsMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)LinkedCart.STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new)), LinkedCartsMessage::linkedCarts, LinkedCartsMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(LinkedCartsMessage message, IPayloadContext context) {
        ClientManager.getShuntingAuraRenderer().setLinkedCarts(message.linkedCarts);
    }

    public record LinkedCart(int entityId, Optional<UUID> trainId, int linkAId, int linkBId) {
        private static final StreamCodec<FriendlyByteBuf, LinkedCart> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, LinkedCart::entityId, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), LinkedCart::trainId, (StreamCodec)ByteBufCodecs.VAR_INT, LinkedCart::linkAId, (StreamCodec)ByteBufCodecs.VAR_INT, LinkedCart::linkBId, LinkedCart::new);

        public LinkedCart(RollingStock extension) {
            this(extension.entity().getId(), Optional.of(extension.train().id()), extension.backLink().map(RollingStock::entity).map(Entity::getId).orElse(-1), extension.frontLink().map(RollingStock::entity).map(Entity::getId).orElse(-1));
        }
    }
}

