/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.placement.VerticalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.BlastFurnaceRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class BlastFurnaceRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<BlastFurnaceRecipe>> {
    private static final int WIDTH = 82;
    private static final int HEIGHT = 54;
    private final IDrawable flame;
    private final IDrawable arrow;

    public BlastFurnaceRecipeCategory(IGuiHelper guiHelper) {
        super(RecipeTypes.BLAST_FURNACE, (Component)Component.translatable((String)Translations.Jei.BLAST_FURNACE), guiHelper.createDrawableItemLike((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()), 82, 54);
        this.flame = guiHelper.createAnimatedRecipeFlame(200);
        this.arrow = guiHelper.createAnimatedRecipeArrow(200);
    }

    public void draw(RecipeHolder<BlastFurnaceRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.flame.draw(guiGraphics, 1, 20);
        this.arrow.draw(guiGraphics, 25, 19);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<BlastFurnaceRecipe> recipeHolder, IFocusGroup focuses) {
        BlastFurnaceRecipe recipe = (BlastFurnaceRecipe)recipeHolder.value();
        int cookTime = recipe.getCookingTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            builder.addText((FormattedText)timeString, 82, 45).setTextAlignment(VerticalAlignment.BOTTOM).setTextAlignment(HorizontalAlignment.CENTER).setColor(-8355712);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<BlastFurnaceRecipe> recipeHolder, IFocusGroup focuses) {
        BlastFurnaceRecipe recipe = (BlastFurnaceRecipe)recipeHolder.value();
        NonNullList ingredients = recipe.getIngredients();
        builder.addInputSlot(1, 1).setStandardSlotBackground().addIngredients((Ingredient)ingredients.getFirst());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1, 37).setStandardSlotBackground();
        builder.addOutputSlot(61, 5).setOutputSlotBackground().addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
        builder.addOutputSlot(61, 37).setStandardSlotBackground().addItemStack(new ItemStack((ItemLike)RailcraftItems.SLAG.get(), recipe.getSlagOutput()));
    }
}

