/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.IExtendableCraftingRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.BlastFurnaceScreen;
import mods.railcraft.client.gui.screen.inventory.CokeOvenScreen;
import mods.railcraft.client.gui.screen.inventory.CrusherScreen;
import mods.railcraft.client.gui.screen.inventory.ManualRollingMachineScreen;
import mods.railcraft.client.gui.screen.inventory.PoweredRollingMachineScreen;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.screen.inventory.SteamOvenScreen;
import mods.railcraft.integrations.jei.DefaultRecipeWrapper;
import mods.railcraft.integrations.jei.GhostIngredientHandler;
import mods.railcraft.integrations.jei.JeiSearchable;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.integrations.jei.category.BlastFurnaceRecipeCategory;
import mods.railcraft.integrations.jei.category.CokeOvenRecipeCategory;
import mods.railcraft.integrations.jei.category.CrusherRecipeCategory;
import mods.railcraft.integrations.jei.category.FluidBoilerRecipeCategory;
import mods.railcraft.integrations.jei.category.RollingRecipeCategory;
import mods.railcraft.integrations.jei.category.SolidBoilerRecipeCategory;
import mods.railcraft.world.inventory.BlastFurnaceMenu;
import mods.railcraft.world.inventory.CokeOvenMenu;
import mods.railcraft.world.inventory.CrusherMenu;
import mods.railcraft.world.inventory.ManualRollingMachineMenu;
import mods.railcraft.world.inventory.PoweredRollingMachineMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.inventory.SteamOvenMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.CartDisassemblyRecipe;
import mods.railcraft.world.item.crafting.LocomotivePaintingRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.item.crafting.RotorRepairRecipe;
import mods.railcraft.world.item.crafting.TicketDuplicateRecipe;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;

@JeiPlugin
public class RailcraftJeiPlugin
implements IModPlugin {
    public static final int TEXT_COLOR = -8355712;

    public ResourceLocation getPluginUid() {
        return RailcraftConstants.rl("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new RollingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CokeOvenRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlastFurnaceRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrusherRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidBoilerRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidBoilerRecipeCategory(guiHelper)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ManualRollingMachineScreen.class, 90, 45, 23, 9, new RecipeType[]{RecipeTypes.ROLLING_MACHINE});
        registration.addRecipeClickArea(PoweredRollingMachineScreen.class, 90, 36, 23, 9, new RecipeType[]{RecipeTypes.ROLLING_MACHINE});
        registration.addRecipeClickArea(CokeOvenScreen.class, 34, 43, 20, 16, new RecipeType[]{RecipeTypes.COKE_OVEN});
        registration.addRecipeClickArea(BlastFurnaceScreen.class, 80, 36, 22, 15, new RecipeType[]{RecipeTypes.BLAST_FURNACE});
        registration.addRecipeClickArea(CrusherScreen.class, 73, 20, 30, 38, new RecipeType[]{RecipeTypes.CRUSHER});
        registration.addRecipeClickArea(SteamOvenScreen.class, 65, 18, 23, 50, new RecipeType[]{mezz.jei.api.constants.RecipeTypes.SMELTING});
        registration.addGhostIngredientHandler(RailcraftMenuScreen.class, new GhostIngredientHandler());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(ManualRollingMachineMenu.class, (MenuType)RailcraftMenuTypes.MANUAL_ROLLING_MACHINE.get(), RecipeTypes.ROLLING_MACHINE, 2, 9, 11, 36);
        registration.addRecipeTransferHandler(PoweredRollingMachineMenu.class, (MenuType)RailcraftMenuTypes.POWERED_ROLLING_MACHINE.get(), RecipeTypes.ROLLING_MACHINE, 2, 9, 11, 36);
        registration.addRecipeTransferHandler(CokeOvenMenu.class, (MenuType)RailcraftMenuTypes.COKE_OVEN.get(), RecipeTypes.COKE_OVEN, 0, 1, 4, 36);
        registration.addRecipeTransferHandler(BlastFurnaceMenu.class, (MenuType)RailcraftMenuTypes.BLAST_FURNACE.get(), RecipeTypes.BLAST_FURNACE, 0, 1, 4, 36);
        registration.addRecipeTransferHandler(CrusherMenu.class, (MenuType)RailcraftMenuTypes.CRUSHER.get(), RecipeTypes.CRUSHER, 0, 9, 17, 36);
        registration.addRecipeTransferHandler(SteamOvenMenu.class, (MenuType)RailcraftMenuTypes.STEAM_OVEN.get(), mezz.jei.api.constants.RecipeTypes.SMELTING, 0, 9, 9, 36);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(RecipeTypes.ROLLING_MACHINE, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RailcraftRecipeTypes.ROLLING.get()));
        registration.addRecipes(RecipeTypes.COKE_OVEN, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RailcraftRecipeTypes.COKING.get()));
        registration.addRecipes(RecipeTypes.BLAST_FURNACE, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RailcraftRecipeTypes.BLASTING.get()));
        registration.addRecipes(RecipeTypes.CRUSHER, recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RailcraftRecipeTypes.CRUSHING.get()));
        registration.addRecipes(RecipeTypes.SOLID_BOILER, SolidBoilerRecipeCategory.getBoilerRecipes());
        registration.addRecipes(RecipeTypes.FLUID_BOILER, FluidBoilerRecipeCategory.getBoilerRecipes());
        RailcraftBlocks.entries().stream().map(DeferredHolder::get).filter(JeiSearchable.class::isInstance).forEach(x -> registration.addItemStackInfo(new ItemStack((ItemLike)x), new Component[]{((JeiSearchable)x).jeiDescription()}));
        RailcraftItems.entries().stream().map(DeferredHolder::get).filter(JeiSearchable.class::isInstance).forEach(x -> registration.addItemStackInfo(new ItemStack((ItemLike)x), new Component[]{((JeiSearchable)x).jeiDescription()}));
    }

    public void registerVanillaCategoryExtensions(final IVanillaCategoryExtensionRegistration registration) {
        IExtendableCraftingRecipeCategory craftingCategory = registration.getCraftingCategory();
        craftingCategory.addExtension(LocomotivePaintingRecipe.class, new DefaultRecipeWrapper(false, (Component)Component.translatable((String)Translations.Jei.PAINT)));
        craftingCategory.addExtension(TicketDuplicateRecipe.class, new DefaultRecipeWrapper(true, (Component)Component.translatable((String)Translations.Jei.COPY_TAG)));
        craftingCategory.addExtension(RotorRepairRecipe.class, new DefaultRecipeWrapper(true, (Component)Component.translatable((String)Translations.Jei.REPAIR)).modifyInputs(stack -> {
            if (stack.is((Item)RailcraftItems.TURBINE_ROTOR.get())) {
                stack.setDamageValue(2500);
            }
        }));
        craftingCategory.addExtension(CartDisassemblyRecipe.class, (ICraftingCategoryExtension)new DefaultRecipeWrapper<CartDisassemblyRecipe>(this, true, (Component)Component.translatable((String)Translations.Jei.SPLIT)){

            @Override
            public void drawInfo(RecipeHolder<CartDisassemblyRecipe> recipe, int recipeWidth, int recipeHeight, GuiGraphics guiGraphics, double mouseX, double mouseY) {
                super.drawInfo(recipe, recipeWidth, recipeHeight, guiGraphics, mouseX, mouseY);
                IDrawable drawable = registration.getJeiHelpers().getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)Items.MINECART));
                drawable.draw(guiGraphics, 65, 35);
            }
        });
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get()), new RecipeType[]{RecipeTypes.ROLLING_MACHINE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.POWERED_ROLLING_MACHINE.get()), new RecipeType[]{RecipeTypes.ROLLING_MACHINE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.COKE_OVEN_BRICKS.get()), new RecipeType[]{RecipeTypes.COKE_OVEN});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()), new RecipeType[]{RecipeTypes.BLAST_FURNACE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.CRUSHER.get()), new RecipeType[]{RecipeTypes.CRUSHER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.STEAM_OVEN.get()), new RecipeType[]{mezz.jei.api.constants.RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.SOLID_FUELED_FIREBOX.get()), new RecipeType[]{RecipeTypes.SOLID_BOILER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.HIGH_PRESSURE_STEAM_BOILER_TANK.get()), new RecipeType[]{RecipeTypes.SOLID_BOILER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.LOW_PRESSURE_STEAM_BOILER_TANK.get()), new RecipeType[]{RecipeTypes.SOLID_BOILER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.FLUID_FUELED_FIREBOX.get()), new RecipeType[]{RecipeTypes.FLUID_BOILER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.HIGH_PRESSURE_STEAM_BOILER_TANK.get()), new RecipeType[]{RecipeTypes.FLUID_BOILER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RailcraftItems.LOW_PRESSURE_STEAM_BOILER_TANK.get()), new RecipeType[]{RecipeTypes.FLUID_BOILER});
    }
}

