/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.network.to_server.SetFilterSlotMessage;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class GhostIngredientHandler<T extends RailcraftMenuScreen<?>>
implements IGhostIngredientHandler<T> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(T gui, ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        for (final Slot slot : ((RailcraftMenu)gui.getMenu()).slots) {
            RailcraftSlot railcraftSlot;
            if (!slot.isActive()) continue;
            final Rect2i bounds = new Rect2i(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, 17, 17);
            Object object = ingredient.getIngredient();
            if (!(object instanceof ItemStack)) continue;
            ItemStack itemStack = (ItemStack)object;
            if (!(slot instanceof RailcraftSlot) || !(railcraftSlot = (RailcraftSlot)slot).isPhantom() || !railcraftSlot.mayPlace(itemStack)) continue;
            targets.add(new IGhostIngredientHandler.Target<I>(this){

                public Rect2i getArea() {
                    return bounds;
                }

                public void accept(I ingredient) {
                    ItemStack itemStack = ((ItemStack)ingredient).copy();
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetFilterSlotMessage(slot.index, itemStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    slot.set(itemStack);
                }
            });
        }
        return targets;
    }

    public void onComplete() {
    }
}

