/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei;

import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;

public class DefaultRecipeWrapper<T extends CraftingRecipe>
implements ICraftingCategoryExtension<T> {
    private final boolean isShapeless;
    private final Component info;
    private Consumer<ItemStack> stackModifier;

    DefaultRecipeWrapper(boolean isShapeless, Component info) {
        this.isShapeless = isShapeless;
        this.info = info;
        this.stackModifier = stack -> {};
    }

    DefaultRecipeWrapper<T> modifyInputs(Consumer<ItemStack> stackModifier) {
        this.stackModifier = stackModifier;
        return this;
    }

    public void drawInfo(RecipeHolder<T> recipe, int recipeWidth, int recipeHeight, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        int stringWidth = font.width((FormattedText)this.info) / 2;
        guiGraphics.drawString(font, this.info, 82 - stringWidth, 0, -8355712, false);
    }

    public void setRecipe(RecipeHolder<T> recipeHolder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        List<List> inputs = ((CraftingRecipe)recipeHolder.value()).getIngredients().stream().map(ingredient -> List.of(ingredient.getItems())).toList();
        inputs.forEach(l -> l.forEach(this.stackModifier));
        RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
        craftingGridHelper.createAndSetOutputs(builder, List.of(((CraftingRecipe)recipeHolder.value()).getResultItem((HolderLookup.Provider)registryAccess)));
        int width = this.getWidth(recipeHolder);
        int height = this.getHeight(recipeHolder);
        craftingGridHelper.createAndSetInputs(builder, inputs, width, height);
    }

    public int getWidth(RecipeHolder<T> recipeHolder) {
        return this.isShapeless ? 0 : 3;
    }

    public int getHeight(RecipeHolder<T> recipeHolder) {
        return this.isShapeless ? 0 : 3;
    }
}

