/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.model.LowSidesMinecartModel;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.renderer.entity.cart.ContentsMinecartRenderer;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.world.entity.vehicle.EnergyMinecart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class EnergyMinecartRenderer
extends ContentsMinecartRenderer<EnergyMinecart> {
    private static final ResourceLocation FRAME = RailcraftConstants.rl("entity/minecart/energy_minecart_flux_frame");
    private static final ResourceLocation CORE = RailcraftConstants.rl("entity/minecart/energy_minecart_flux_core");
    private static final float PIXEL_OFFSET = 0.03125f;
    private static final CuboidModel FRAME_MODEL = new CuboidModel(0.03125f, 0.03125f, 0.03125f, 0.96875f, 0.96875f, 0.96875f);
    private static final CuboidModel CORE_MODEL = new CuboidModel(0.0625f, 0.0625f, 0.0625f, 0.9375f, 0.9375f, 0.9375f);
    private final LowSidesMinecartModel<EnergyMinecart> bodyModel;
    private final LowSidesMinecartModel<EnergyMinecart> snowModel;

    public EnergyMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.bodyModel = new LowSidesMinecartModel(context.bakeLayer(RailcraftModelLayers.LOW_SIDES_MINECART));
        this.snowModel = new LowSidesMinecartModel(context.bakeLayer(RailcraftModelLayers.LOW_SIDES_MINECART_SNOW));
    }

    @Override
    protected void renderContents(EnergyMinecart cart, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int color) {
        Minecraft minecraft = Minecraft.getInstance();
        CuboidModel.Face frameFace = new CuboidModel.Face(FRAME_MODEL).setSprite((TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(FRAME));
        CuboidModel.Face coreFace = new CuboidModel.Face(CORE_MODEL).setSprite((TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(CORE));
        FRAME_MODEL.setAll(frameFace);
        FRAME_MODEL.setPackedLight(packedLight);
        FRAME_MODEL.setPackedOverlay(OverlayTexture.NO_OVERLAY);
        CORE_MODEL.setAll(coreFace);
        CORE_MODEL.setPackedLight(packedLight);
        CORE_MODEL.setPackedOverlay(OverlayTexture.NO_OVERLAY);
        poseStack.pushPose();
        VertexConsumer vertexBuilder = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        CuboidModelRenderer.render(FRAME_MODEL, poseStack, vertexBuilder, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
        CuboidModelRenderer.render(CORE_MODEL, poseStack, vertexBuilder, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
        poseStack.popPose();
    }

    @Override
    protected EntityModel<? super EnergyMinecart> getBodyModel(EnergyMinecart cart) {
        return this.bodyModel;
    }

    @Override
    protected EntityModel<? super EnergyMinecart> getSnowModel(EnergyMinecart cart) {
        return this.snowModel;
    }
}

