/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;

public class TankRenderer
implements BlockEntityRenderer<TankBlockEntity> {
    public boolean shouldRenderOffScreen(TankBlockEntity blockEntity) {
        return true;
    }

    public boolean shouldRender(TankBlockEntity blockEntity, Vec3 cameraPos) {
        return blockEntity.isMaster() && super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public void render(TankBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        VertexConsumer consumer = bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        int maxY = blockEntity.getMaxY();
        StandardTank tank = blockEntity.getModule().getTank();
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        poseStack.translate(-0.99609375f, 1.0f, -0.99609375f);
        float twoPixels = 0.0078125f;
        float fluidMaxX = (float)blockEntity.getMaxX() - 0.0078125f;
        float fluidMaxZ = (float)blockEntity.getMaxZ() - 0.0078125f;
        float capacity = tank.getCapacity();
        float level = Math.min((float)fluidStack.getAmount() / capacity, 1.0f);
        float fluidMaxY = ((float)maxY - 2.0f) * level;
        CuboidModel model = FluidRenderer.getFluidModel(fluidStack, fluidMaxX, fluidMaxY, fluidMaxZ, FluidRenderer.FluidType.STILL);
        poseStack.pushPose();
        model.setPackedLight(RenderUtil.calculateGlowLight(packedLight, fluidStack));
        model.setPackedOverlay(packedOverlay);
        CuboidModelRenderer.render(model, poseStack, consumer, RenderUtil.getColorARGB(fluidStack, 1.0f), CuboidModelRenderer.FaceDisplay.FRONT, true);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(TankBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

