/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.renderer.blockentity.FluidManipulatorRenderer;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.world.level.block.entity.manipulator.FluidLoaderBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.AABB;

public class FluidLoaderRenderer
extends FluidManipulatorRenderer<FluidLoaderBlockEntity> {
    private static final float PIPE_OFFSET = 0.3125f;
    private static final ResourceLocation PIPE_SIDE_TEXTURE_LOCATION = RailcraftConstants.rl("entity/fluid_loader/pipe_side");
    private static final ResourceLocation PIPE_END_TEXTURE_LOCATION = RailcraftConstants.rl("entity/fluid_loader/pipe_end");
    private static final CuboidModel PIPE_MODEL = new CuboidModel(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.0625f, 0.6875f);

    @Override
    public void render(FluidLoaderBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        Minecraft minecraft = Minecraft.getInstance();
        CuboidModel.Face sideFace = new CuboidModel.Face(PIPE_MODEL).setSprite((TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(PIPE_SIDE_TEXTURE_LOCATION));
        PIPE_MODEL.set(Direction.NORTH, sideFace);
        PIPE_MODEL.set(Direction.SOUTH, sideFace);
        PIPE_MODEL.set(Direction.EAST, sideFace);
        PIPE_MODEL.set(Direction.WEST, sideFace);
        CuboidModel.Face endFace = new CuboidModel.Face(PIPE_MODEL).setSprite((TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(PIPE_END_TEXTURE_LOCATION));
        PIPE_MODEL.set(Direction.UP, endFace);
        PIPE_MODEL.set(Direction.DOWN, endFace);
        PIPE_MODEL.setPackedLight(packedLight);
        PIPE_MODEL.setPackedOverlay(packedOverlay);
        poseStack.pushPose();
        PIPE_MODEL.setMinY(0.0625f - blockEntity.getPipeLength(partialTick));
        VertexConsumer vertexBuilder = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        CuboidModelRenderer.render(PIPE_MODEL, poseStack, vertexBuilder, -1, CuboidModelRenderer.FaceDisplay.BOTH, false);
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(FluidLoaderBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)(pos.getY() - 1), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
    }
}

