/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.RailcraftPageButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.network.to_server.EditRoutingTableBookMessage;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.RoutingTableBookContent;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class RoutingTableBookScreen
extends Screen {
    public static final ResourceLocation BOOK_LOCATION = RailcraftConstants.rl("textures/gui/item/routing_table_book.png");
    private static final int TEXT_WIDTH = 220;
    private static final int TEXT_HEIGHT = 128;
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 192;
    private static final int BOOK_MAX_PAGES = 50;
    private static final Component EDIT_TITLE_LABEL = Component.translatable((String)"book.editTitle");
    private static final FormattedCharSequence BLACK_CURSOR = FormattedCharSequence.forward((String)"_", (Style)Style.EMPTY.withColor(ChatFormatting.BLACK));
    private static final FormattedCharSequence GRAY_CURSOR = FormattedCharSequence.forward((String)"_", (Style)Style.EMPTY.withColor(ChatFormatting.GRAY));
    private final Player owner;
    private final ItemStack book;
    private final InteractionHand hand;
    private boolean isModified;
    private boolean editingTitle;
    private int frameTick;
    private int currentPage;
    private final List<String> pages = Lists.newArrayList();
    private String title = "";
    private final TextFieldHelper pageEdit = new TextFieldHelper(this::getCurrentPageText, this::setCurrentPageText, this::getClipboard, this::setClipboard, s -> s.length() < 1024 && this.font.wordWrapHeight(s, 220) <= 128);
    private final TextFieldHelper titleEdit = new TextFieldHelper(() -> this.title, s -> {
        this.title = s;
    }, this::getClipboard, this::setClipboard, s -> s.length() < 16);
    private long lastClickTime;
    private int lastIndex = -1;
    private PageButton forwardButton;
    private PageButton backButton;
    private RailcraftButton titleButton;
    private RailcraftButton helpButton;
    @Nullable
    private DisplayCache displayCache = DisplayCache.EMPTY;
    private Component pageMsg = CommonComponents.EMPTY;
    private final Component ownerText;
    private boolean readingManual;
    private final int numManualPages;

    public RoutingTableBookScreen(Player owner, ItemStack book, InteractionHand hand) {
        super(GameNarrator.NO_TITLE);
        this.owner = owner;
        this.book = book;
        this.hand = hand;
        this.ownerText = Component.translatable((String)"book.byAuthor", (Object[])new Object[]{owner.getName()}).withStyle(ChatFormatting.DARK_GRAY);
        RoutingTableBookContent writableBookContent = (RoutingTableBookContent)book.get(RailcraftDataComponents.ROUTING_TABLE_BOOK);
        if (writableBookContent != null) {
            this.pages.addAll(writableBookContent.pages());
        }
        if (this.pages.isEmpty()) {
            this.pages.add("");
        }
        this.numManualPages = Translations.RoutingTable.MANUAL_PAGES.size();
    }

    private void setClipboard(String s) {
        if (this.minecraft != null) {
            TextFieldHelper.setClipboardContents((Minecraft)this.minecraft, (String)s);
        }
    }

    private String getClipboard() {
        return this.minecraft != null ? TextFieldHelper.getClipboardContents((Minecraft)this.minecraft) : "";
    }

    private int getNumPages() {
        return this.pages.size();
    }

    public void tick() {
        super.tick();
        ++this.frameTick;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.clearDisplayCache();
        this.titleButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.NAME, button -> {
            this.editingTitle = !this.editingTitle;
            this.readingManual = false;
            this.currentPage = 0;
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        this.helpButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.HELP, button -> {
            this.readingManual = !this.readingManual;
            this.editingTitle = false;
            this.currentPage = 0;
            this.clearDisplayCacheAfterPageChange();
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        RailcraftButton doneButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.GUI_DONE, button -> {
            this.saveChanges();
            this.minecraft.setScreen(null);
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        LinearLayout layout = new LinearLayout(this.width / 2 - 100, this.height / 2 + 90, LinearLayout.Orientation.HORIZONTAL);
        layout.spacing(4);
        layout.addChild((LayoutElement)this.titleButton);
        layout.addChild((LayoutElement)this.helpButton);
        layout.addChild((LayoutElement)doneButton);
        layout.arrangeElements();
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new RailcraftPageButton(xOffset + 200, yOffset + 150, true, BOOK_LOCATION, button -> this.pageForward()));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new RailcraftPageButton(xOffset + 30, yOffset + 150, false, BOOK_LOCATION, button -> this.pageBack()));
        this.updateButtonVisibility();
    }

    private void pageForward() {
        if (this.readingManual) {
            if (this.currentPage < this.getMaxPages() - 1) {
                ++this.currentPage;
            }
            return;
        }
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        } else {
            this.appendPageToBook();
            if (this.currentPage < this.getNumPages() - 1) {
                ++this.currentPage;
            }
        }
        this.updateButtonVisibility();
        this.clearDisplayCacheAfterPageChange();
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        if (!this.readingManual) {
            this.updateButtonVisibility();
            this.clearDisplayCacheAfterPageChange();
        }
    }

    private void updateButtonVisibility() {
        this.forwardButton.visible = !this.editingTitle && this.currentPage < this.getMaxPages() - 1;
        this.backButton.visible = !this.editingTitle && this.currentPage > 0;
        this.helpButton.setMessage((Component)(this.readingManual ? CommonComponents.GUI_BACK : Component.translatable((String)Translations.Screen.HELP)));
        this.titleButton.setMessage((Component)(this.editingTitle ? CommonComponents.GUI_BACK : Component.translatable((String)Translations.Screen.NAME)));
    }

    private int getMaxPages() {
        if (this.readingManual) {
            return this.numManualPages;
        }
        if (this.editingTitle) {
            return 0;
        }
        return 50;
    }

    private void eraseEmptyTrailingPages() {
        ListIterator<String> listiterator = this.pages.listIterator(this.pages.size());
        while (listiterator.hasPrevious() && listiterator.previous().isEmpty()) {
            listiterator.remove();
        }
    }

    private void saveChanges() {
        if (this.isModified) {
            this.eraseEmptyTrailingPages();
            this.updateLocalCopy();
            PacketDistributor.sendToServer((CustomPacketPayload)new EditRoutingTableBookMessage(this.hand, this.pages, Optional.of(this.title.trim())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void updateLocalCopy() {
        this.book.set(RailcraftDataComponents.ROUTING_TABLE_BOOK, (Object)new RoutingTableBookContent(this.pages, this.owner.getGameProfile().getName(), Optional.of(this.title.trim())));
    }

    private void appendPageToBook() {
        if (this.getNumPages() < 50) {
            this.pages.add("");
            this.isModified = true;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.editingTitle) {
            return this.titleKeyPressed(keyCode, scanCode, modifiers);
        }
        if (this.bookKeyPressed(keyCode, scanCode, modifiers)) {
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (super.charTyped(codePoint, modifiers)) {
            return true;
        }
        if (this.editingTitle) {
            if (this.titleEdit.charTyped(codePoint)) {
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
            return false;
        }
        if (StringUtil.isAllowedChatCharacter((char)codePoint)) {
            this.pageEdit.insertText(Character.toString(codePoint));
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    private boolean bookKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (Screen.isSelectAll((int)keyCode)) {
            this.pageEdit.selectAll();
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            this.pageEdit.copy();
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            this.pageEdit.paste();
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            this.pageEdit.cut();
            return true;
        }
        TextFieldHelper.CursorStep cursorStep = Screen.hasControlDown() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        switch (keyCode) {
            case 257: 
            case 335: {
                this.pageEdit.insertText("\n");
                return true;
            }
            case 259: {
                this.pageEdit.removeFromCursor(-1, cursorStep);
                return true;
            }
            case 261: {
                this.pageEdit.removeFromCursor(1, cursorStep);
                return true;
            }
            case 262: {
                this.pageEdit.moveBy(1, Screen.hasShiftDown(), cursorStep);
                return true;
            }
            case 263: {
                this.pageEdit.moveBy(-1, Screen.hasShiftDown(), cursorStep);
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 266: {
                this.backButton.onPress();
                return true;
            }
            case 267: {
                this.forwardButton.onPress();
                return true;
            }
            case 268: {
                this.keyHome();
                return true;
            }
            case 269: {
                this.keyEnd();
                return true;
            }
        }
        return false;
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int yChange) {
        int i = this.pageEdit.getCursorPos();
        int j = this.getDisplayCache().changeLine(i, yChange);
        this.pageEdit.setCursorPos(j, Screen.hasShiftDown());
    }

    private void keyHome() {
        if (Screen.hasControlDown()) {
            this.pageEdit.setCursorToStart(Screen.hasShiftDown());
        } else {
            int i = this.pageEdit.getCursorPos();
            int j = this.getDisplayCache().findLineStart(i);
            this.pageEdit.setCursorPos(j, Screen.hasShiftDown());
        }
    }

    private void keyEnd() {
        if (Screen.hasControlDown()) {
            this.pageEdit.setCursorToEnd(Screen.hasShiftDown());
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            int i = this.pageEdit.getCursorPos();
            int j = displayCache.findLineEnd(i);
            this.pageEdit.setCursorPos(j, Screen.hasShiftDown());
        }
    }

    private boolean titleKeyPressed(int keyCode, int pScanCode, int pModifiers) {
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.saveChanges();
                    this.minecraft.setScreen(null);
                }
                return true;
            }
            case 259: {
                this.titleEdit.removeCharsFromCursor(-1);
                this.updateButtonVisibility();
                this.isModified = true;
                return true;
            }
        }
        return false;
    }

    private String getCurrentPageText() {
        return this.currentPage >= 0 && this.currentPage < this.pages.size() ? this.pages.get(this.currentPage) : "";
    }

    private void setCurrentPageText(String text) {
        if (this.currentPage >= 0 && this.currentPage < this.pages.size()) {
            this.pages.set(this.currentPage, text);
            this.isModified = true;
            this.clearDisplayCache();
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.setFocused(null);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BOOK_LOCATION);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        guiGraphics.blit(BOOK_LOCATION, xOffset, yOffset, 0, 0, 256, 192);
        if (this.editingTitle) {
            boolean flag = this.frameTick / 6 % 2 == 0;
            FormattedCharSequence formattedcharsequence = FormattedCharSequence.composite((FormattedCharSequence)FormattedCharSequence.forward((String)this.title, (Style)Style.EMPTY), (FormattedCharSequence)(flag ? BLACK_CURSOR : GRAY_CURSOR));
            int l = this.font.width((FormattedText)EDIT_TITLE_LABEL);
            guiGraphics.drawString(this.font, EDIT_TITLE_LABEL, xOffset + 160 - l, yOffset + 34, 0, false);
            int l1 = this.font.width(formattedcharsequence);
            guiGraphics.drawString(this.font, formattedcharsequence, xOffset + 120 - l1 / 2, yOffset + 50, 0, false);
            int l2 = this.font.width((FormattedText)this.ownerText);
            guiGraphics.drawString(this.font, this.ownerText, xOffset + 130 - l2, yOffset + 60, 0, false);
        } else if (this.readingManual) {
            MutableComponent manualPageIndicator = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.getMaxPages()});
            int l = this.font.width((FormattedText)manualPageIndicator);
            guiGraphics.drawString(this.font, (Component)manualPageIndicator, xOffset - l + 225, yOffset + 15, 0, false);
            MutableComponent page = Component.translatable((String)Translations.RoutingTable.MANUAL_PAGES.get(this.currentPage));
            guiGraphics.drawWordWrap(this.font, (FormattedText)page, xOffset + 20, yOffset + 27, 220, -12566464);
        } else {
            int l = this.font.width((FormattedText)this.pageMsg);
            guiGraphics.drawString(this.font, this.pageMsg, xOffset - l + 225, yOffset + 15, 0, false);
            DisplayCache displayCache = this.getDisplayCache();
            for (LineInfo lineinfo : displayCache.lines) {
                guiGraphics.drawString(this.font, lineinfo.asComponent, lineinfo.x, lineinfo.y, -16777216, false);
            }
            this.renderHighlight(guiGraphics, displayCache.selection);
            this.renderCursor(guiGraphics, displayCache.cursor, displayCache.cursorAtEnd);
        }
        this.updateButtonVisibility();
    }

    private void renderCursor(GuiGraphics guiGraphics, Pos2i cursorPos, boolean isEndOfText) {
        if (this.frameTick / 6 % 2 == 0) {
            cursorPos = this.convertLocalToScreen(cursorPos);
            if (!isEndOfText) {
                guiGraphics.fill(cursorPos.x, cursorPos.y - 1, cursorPos.x + 1, cursorPos.y + 9, -16777216);
            } else {
                guiGraphics.drawString(this.font, "_", cursorPos.x, cursorPos.y, 0, false);
            }
        }
    }

    private void renderHighlight(GuiGraphics guiGraphics, Rect2i[] selected) {
        for (Rect2i rect2i : selected) {
            int i = rect2i.getX();
            int j = rect2i.getY();
            int k = i + rect2i.getWidth();
            int l = j + rect2i.getHeight();
            guiGraphics.fill(RenderType.guiTextHighlight(), i, j, k, l, -16776961);
        }
    }

    private Pos2i convertScreenToLocal(Pos2i screenPos) {
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        int x = screenPos.x - xOffset - 20;
        int y = screenPos.y - yOffset - 27;
        return new Pos2i(x, y);
    }

    private Pos2i convertLocalToScreen(Pos2i localScreenPos) {
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        int x = localScreenPos.x + xOffset + 20;
        int y = localScreenPos.y + yOffset + 27;
        return new Pos2i(x, y);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            long i = Util.getMillis();
            DisplayCache displayCache = this.getDisplayCache();
            int j = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (j >= 0) {
                if (j == this.lastIndex && i - this.lastClickTime < 250L) {
                    if (!this.pageEdit.isSelecting()) {
                        this.selectWord(j);
                    } else {
                        this.pageEdit.selectAll();
                    }
                } else {
                    this.pageEdit.setCursorPos(j, Screen.hasShiftDown());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = j;
            this.lastClickTime = i;
        }
        return true;
    }

    private void selectWord(int pIndex) {
        String s = this.getCurrentPageText();
        this.pageEdit.setSelectionRange(StringSplitter.getWordPosition((String)s, (int)-1, (int)pIndex, (boolean)false), StringSplitter.getWordPosition((String)s, (int)1, (int)pIndex, (boolean)false));
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button == 0) {
            DisplayCache displayCache = this.getDisplayCache();
            int i = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            this.pageEdit.setCursorPos(i, true);
            this.clearDisplayCache();
        }
        return true;
    }

    private DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
            this.pageMsg = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.getNumPages()});
        }
        return this.displayCache;
    }

    private void clearDisplayCache() {
        this.displayCache = null;
    }

    private void clearDisplayCacheAfterPageChange() {
        this.pageEdit.setCursorToEnd();
        this.clearDisplayCache();
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i pos;
        boolean flag;
        String s = this.getCurrentPageText();
        if (s.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        int i = this.pageEdit.getCursorPos();
        int j = this.pageEdit.getSelectionPos();
        IntArrayList intlist = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        StringSplitter stringsplitter = this.font.getSplitter();
        stringsplitter.splitLines(s, 220, Style.EMPTY, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$9(mutableint, s, mutableboolean, (IntList)intlist, list, arg_0, arg_1, arg_2));
        int[] aint = intlist.toIntArray();
        boolean bl = flag = i == s.length();
        if (flag && mutableboolean.isTrue()) {
            pos = new Pos2i(0, list.size() * 9);
        } else {
            int k = RoutingTableBookScreen.findLineFromPos(aint, i);
            int l = this.font.width(s.substring(aint[k], i));
            pos = new Pos2i(l, k * 9);
        }
        ArrayList list1 = Lists.newArrayList();
        if (i != j) {
            int k1;
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = RoutingTableBookScreen.findLineFromPos(aint, l2);
            if (j1 == (k1 = RoutingTableBookScreen.findLineFromPos(aint, i1))) {
                int l1 = j1 * 9;
                int i2 = aint[j1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > aint.length ? s.length() : aint[j1 + 1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i3, j1 * 9, aint[j1]));
                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(aint[j3], aint[j3 + 1]);
                    int k2 = (int)stringsplitter.stringWidth(s1);
                    list1.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                list1.add(this.createPartialLineSelection(s, stringsplitter, aint[k1], i1, k1 * 9, aint[k1]));
            }
        }
        return new DisplayCache(s, pos, flag, aint, list.toArray(new LineInfo[0]), list1.toArray(new Rect2i[0]));
    }

    static int findLineFromPos(int[] lineStarts, int find) {
        int i = Arrays.binarySearch(lineStarts, find);
        return i < 0 ? -(i + 2) : i;
    }

    private Rect2i createPartialLineSelection(String input, StringSplitter splitter, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s = input.substring(p_98125_, p_98122_);
        String s1 = input.substring(p_98125_, p_98123_);
        Pos2i corner1 = new Pos2i((int)splitter.stringWidth(s), p_98124_);
        Pos2i corner2 = new Pos2i((int)splitter.stringWidth(s1), p_98124_ + 9);
        return this.createSelection(corner1, corner2);
    }

    private Rect2i createSelection(Pos2i pCorner1, Pos2i pCorner2) {
        Pos2i pos = this.convertLocalToScreen(pCorner1);
        Pos2i pos1 = this.convertLocalToScreen(pCorner2);
        int i = Math.min(pos.x, pos1.x);
        int j = Math.max(pos.x, pos1.x);
        int k = Math.min(pos.y, pos1.y);
        int l = Math.max(pos.y, pos1.y);
        return new Rect2i(i, k, j - i, l - k);
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$9(MutableInt mutableint, String s, MutableBoolean mutableboolean, IntList intlist, List list, Style style, int beginIndex, int endIndex) {
        int k3 = mutableint.getAndIncrement();
        String s2 = s.substring(beginIndex, endIndex);
        mutableboolean.setValue(s2.endsWith("\n"));
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        int l3 = k3 * 9;
        Pos2i pos = this.convertLocalToScreen(new Pos2i(0, l3));
        intlist.add(beginIndex);
        list.add(new LineInfo(style, s3, pos.x, pos.y));
    }

    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(Style.EMPTY, "", 0, 0)}, new Rect2i[0]);
        private final String fullText;
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final Rect2i[] selection;

        public DisplayCache(String fullText, Pos2i cursor, boolean cursorAtEnd, int[] lineStarts, LineInfo[] lines, Rect2i[] selection) {
            this.fullText = fullText;
            this.cursor = cursor;
            this.cursorAtEnd = cursorAtEnd;
            this.lineStarts = lineStarts;
            this.lines = lines;
            this.selection = selection;
        }

        public int getIndexAtPosition(Font font, Pos2i cursorPosition) {
            int i = cursorPosition.y / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            return this.lineStarts[i] + font.getSplitter().plainIndexAtWidth(this.lines[i].contents, cursorPosition.x, this.lines[i].style);
        }

        public int changeLine(int xChange, int yChange) {
            int k;
            int i = RoutingTableBookScreen.findLineFromPos(this.lineStarts, xChange);
            int j = i + yChange;
            if (0 <= j && j < this.lineStarts.length) {
                int l = xChange - this.lineStarts[i];
                int i1 = this.lines[j].contents.length();
                k = this.lineStarts[j] + Math.min(l, i1);
            } else {
                k = xChange;
            }
            return k;
        }

        public int findLineStart(int line) {
            int i = RoutingTableBookScreen.findLineFromPos(this.lineStarts, line);
            return this.lineStarts[i];
        }

        public int findLineEnd(int line) {
            int i = RoutingTableBookScreen.findLineFromPos(this.lineStarts, line);
            return this.lineStarts[i] + this.lines[i].contents.length();
        }
    }

    static class LineInfo {
        final Style style;
        final String contents;
        final Component asComponent;
        final int x;
        final int y;

        public LineInfo(Style style, String contents, int x, int y) {
            this.style = style;
            this.contents = contents;
            this.x = x;
            this.y = y;
            this.asComponent = Component.literal((String)contents).setStyle(style);
        }
    }

    record Pos2i(int x, int y) {
    }
}

