/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.charge;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.energy.IEnergyStorage;

public interface ChargeStorage
extends IEnergyStorage {
    public BlockPos getBlockPos();

    public int getMaxDraw();

    default public int getPotentialDraw() {
        return Mth.clamp((int)this.getMaxDraw(), (int)0, (int)this.getEnergyStored());
    }

    default public int getAvailableCharge() {
        return this.getEnergyStored();
    }

    default public float getEfficiency() {
        return 1.0f;
    }

    default public boolean isFull() {
        return this.getEnergyStored() >= this.getMaxEnergyStored();
    }

    default public State getState() {
        return State.RECHARGEABLE;
    }

    default public void setState(State state) {
    }

    public static enum State {
        INFINITE,
        SOURCE,
        RECHARGEABLE,
        DISPOSABLE,
        DISABLED;

    }

    public record Spec(State initialState, int capacity, int maxDraw, float efficiency) {
    }
}

