/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.pumpkillager;

import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpectralArrowItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Prisoner {
    public static Villager createPrisoner(Level level, BlockPos pos, Player player, VillagerProfession profession, ItemStack headStack, ChatFormatting nameColour, boolean isKnown) {
        Villager prisoner = (Villager)EntityType.VILLAGER.create(level);
        if (profession == null) {
            prisoner.setVillagerData(prisoner.getVillagerData().setType(VillagerType.SNOW));
        } else {
            prisoner.setVillagerData(prisoner.getVillagerData().setType(VillagerType.SNOW).setProfession(profession));
        }
        Vec3 prisonerVec = new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        prisoner.setPos(prisonerVec.x, prisonerVec.y, prisonerVec.z);
        prisoner.setItemSlot(EquipmentSlot.HEAD, headStack);
        if (!isKnown) {
            prisoner.setCustomName((Component)Component.translatable((String)"Prisoner").withStyle(nameColour));
        } else {
            prisoner.setCustomName((Component)Component.translatable((String)"Jax o'Saturn").withStyle(nameColour));
        }
        prisoner.addEffect(new MobEffectInstance(MobEffects.REGENERATION, Integer.MAX_VALUE));
        prisoner.getTags().add("pumpkillagersquest.prisoner");
        prisoner.getTags().add("pumpkillagersquest.justadded");
        Data.allPrisoners.get(level).add(prisoner);
        Data.prisonerPositions.put(prisoner, prisonerVec);
        return prisoner;
    }

    public static void checkForSpectralArrows(Level level, Villager pumpkillager, Player player) {
        if (player.getTags().contains("pumpkillagersquest.extraarrows")) {
            return;
        }
        boolean foundSpectralArrowsInInventory = false;
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (!(inventory.getItem(i).getItem() instanceof SpectralArrowItem)) continue;
            foundSpectralArrowsInInventory = true;
            break;
        }
        if (foundSpectralArrowsInInventory) {
            return;
        }
        Conversations.sendJaxMessage(level, player, "How could you forget to bring the spectral arrows I gave you? You fool!", ChatFormatting.WHITE, 1000);
        Conversations.sendJaxMessage(level, player, "Luckily I've got some magic energy left. Take these.", ChatFormatting.WHITE, 3000, new ItemStack((ItemLike)Items.SPECTRAL_ARROW, 2), "give");
        player.getTags().add("pumpkillagersquest.extraarrows");
    }
}

