/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_forge.pumpkillager;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.pumpkillagersquest_common_forge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_forge.services.Services;
import com.natamus.pumpkillagersquest_common_forge.util.Data;
import com.natamus.pumpkillagersquest_common_forge.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Manage {
    public static void spawnPumpkillager(Level level, Player player, BlockPos pos) {
        Manage.spawnPumpkillager(level, player, pos, 0, 0);
    }

    public static void spawnPumpkillager(Level level, Player player, BlockPos pos, int conversationId, int placementId) {
        if (!Data.allPumpkillagers.containsKey(level)) {
            Data.allPumpkillagers.put(level, new CopyOnWriteArrayList());
        }
        Villager pumpkillager = Manage.createPumpkillager(level, pos, player, null, SpookyHeads.getJackoLantern(1), ChatFormatting.YELLOW, "1.0", false);
        if (conversationId == 0) {
            pumpkillager.getTags().add("pumpkillagersquest.initialencounter");
        }
        level.addFreshEntity((Entity)pumpkillager);
        pumpkillager.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
        Manage.placePumpkillagerBlocks(level, pos, placementId);
        Services.PUMPKILLAGER_API.pumpkillagerSummonEvent(player, pumpkillager, pos, conversationId == 0 ? "INITIAL_SUMMON" : "POST_RITUAL");
        Conversations.startTalking(level, pumpkillager, player, conversationId);
    }

    public static Villager createPumpkillager(Level level, BlockPos pos, Player player, VillagerProfession profession, ItemStack headStack, ChatFormatting nameColour, String scaleFloatString, boolean replace) {
        Villager oldpumpkillager = null;
        Set oldtags = Set.of("");
        if (replace) {
            for (Entity ea : level.getEntities(null, new AABB((double)(pos.getX() - 1), (double)(pos.getY() - 1), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)))) {
                if (!Util.isPumpkillager(ea)) continue;
                oldpumpkillager = (Villager)ea;
                oldtags = oldpumpkillager.getTags();
                break;
            }
        }
        Villager pumpkillager = (Villager)EntityType.VILLAGER.create(level);
        if (profession == null) {
            pumpkillager.setVillagerData(pumpkillager.getVillagerData().setType(VillagerType.SNOW));
        } else {
            pumpkillager.setVillagerData(pumpkillager.getVillagerData().setType(VillagerType.SNOW).setProfession(profession));
        }
        Object pumpkillagerName = "The Pumpkillager";
        if (!scaleFloatString.equals("1.0")) {
            pumpkillagerName = "The Pumpkillager|" + scaleFloatString;
        }
        pumpkillager.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        pumpkillager.setItemSlot(EquipmentSlot.HEAD, headStack);
        pumpkillager.setCustomName((Component)Component.literal((String)pumpkillagerName).withStyle(nameColour));
        pumpkillager.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, Integer.MAX_VALUE));
        pumpkillager.getBrain().removeAllBehaviors();
        pumpkillager.getTags().add("pumpkillagersquest.justadded");
        EntityFunctions.setEntitySize((Entity)pumpkillager, (EntityDimensions)Util.getDefaultVillagerDimensions().scale(Float.parseFloat(scaleFloatString)), (float)pumpkillager.getEyeHeight());
        EntityFunctions.forceSetHealth((LivingEntity)pumpkillager, (float)Data.pumpkillagerMaxHealth);
        for (String tag : oldtags) {
            pumpkillager.getTags().add(tag);
        }
        if (oldpumpkillager != null) {
            pumpkillager.setYHeadRot(oldpumpkillager.getYHeadRot());
            pumpkillager.setYBodyRot(oldpumpkillager.yBodyRot);
            pumpkillager.setXRot(oldpumpkillager.getXRot());
            pumpkillager.setYRot(oldpumpkillager.getYRot());
        }
        ItemStack scaleBarrier = new ItemStack((ItemLike)Items.BARRIER, 64);
        scaleBarrier.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)scaleFloatString));
        pumpkillager.setItemSlot(EquipmentSlot.FEET, scaleBarrier);
        Data.pumpkillagerPlayerTarget.put(pumpkillager, player);
        Data.allPumpkillagers.get(level).add(pumpkillager);
        Data.pumpkillagerPositions.put(pumpkillager, pumpkillager.position());
        if (oldpumpkillager != null) {
            Data.pumpkillagerPlayerTarget.remove(oldpumpkillager);
            Data.allPumpkillagers.get(level).remove(oldpumpkillager);
            Data.pumpkillagerPositions.remove(oldpumpkillager);
            oldpumpkillager.remove(Entity.RemovalReason.DISCARDED);
        }
        return pumpkillager;
    }

    public static void placePumpkillagerBlocks(Level level, BlockPos pos, int placementId) {
        ArrayList<BlockPos> processedPoss = new ArrayList<BlockPos>();
        ArrayList<Pair> currentStates = new ArrayList<Pair>();
        if (placementId == 0) {
            BlockPos below = pos.below().immutable();
            currentStates.add(new Pair((Object)below, (Object)level.getBlockState(below)));
            level.setBlock(below, Blocks.CRYING_OBSIDIAN.defaultBlockState(), 3);
            processedPoss.add(below);
            for (BlockPos ap : Util.getSidePositions(below)) {
                currentStates.add(new Pair((Object)ap, (Object)level.getBlockState(ap)));
                level.setBlock(ap, Blocks.OBSIDIAN.defaultBlockState(), 3);
                processedPoss.add(ap);
            }
            for (BlockPos ap : Util.getSidePositions(pos)) {
                currentStates.add(new Pair((Object)ap, (Object)level.getBlockState(ap)));
                level.setBlock(ap, Blocks.BLACKSTONE_WALL.defaultBlockState(), 3);
                processedPoss.add(ap);
            }
            for (BlockPos ap : Util.getSidePositions(pos.above())) {
                currentStates.add(new Pair((Object)ap.immutable(), (Object)level.getBlockState(ap)));
                level.setBlock(ap, Blocks.SOUL_LANTERN.defaultBlockState(), 3);
                processedPoss.add(ap);
            }
        } else if (placementId == 1) {
            BlockPos belowPos = pos.below().immutable();
            currentStates.add(new Pair((Object)belowPos, (Object)level.getBlockState(belowPos)));
            level.setBlock(belowPos, Blocks.OBSIDIAN.defaultBlockState(), 3);
            processedPoss.add(belowPos);
        } else {
            return;
        }
        Data.globalProcessedPoss.addAll(processedPoss);
        Data.previousStates.put(pos, currentStates);
    }

    public static void resetPlacedBlocks(Level level, Villager pumpkillager) {
        Manage.resetPlacedBlocks(level, pumpkillager.blockPosition());
    }

    public static void resetPlacedBlocks(Level level, BlockPos pos) {
        if (Data.previousStates.containsKey(pos)) {
            Collections.reverse(Data.previousStates.get(pos));
            for (Pair<BlockPos, BlockState> replacePair : Data.previousStates.get(pos)) {
                try {
                    level.setBlock((BlockPos)replacePair.getFirst(), (BlockState)replacePair.getSecond(), 3);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                Data.globalProcessedPoss.remove(pos);
            }
            Data.previousStates.remove(pos);
        }
    }

    public static void yeetLivingEntityIntoSky(Level level, LivingEntity livingEntity) {
        BlockPos pos = livingEntity.blockPosition();
        livingEntity.getTags().add("pumpkillagersquest.removed");
        livingEntity.setNoGravity(true);
        Data.entitiesToYeet.get(level).add(livingEntity);
    }

    public static void pumpkillagerMovedWrongly(Level level, Entity pumpkillager, Player player) {
        Manage.pumpkillagerMovedWrongly(level, (Villager)pumpkillager, player);
    }

    public static void pumpkillagerMovedWrongly(Level level, Villager pumpkillager, Player player) {
        if (!Data.pumpkillagerPositions.containsKey(pumpkillager)) {
            return;
        }
        if (!pumpkillager.getTags().contains("pumpkillagersquest.isleaving")) {
            Vec3 pumpkillagerVec = Data.pumpkillagerPositions.get(pumpkillager);
            pumpkillager.setPos(pumpkillagerVec);
        }
    }

    public static void initiateCharacterLeave(Level level, Villager character) {
        ServerBossEvent serverBossEvent;
        character.getTags().add("pumpkillagersquest.isleaving");
        if (!level.isClientSide && (serverBossEvent = Data.pumpkillagerBossEvents.get(character)) != null) {
            serverBossEvent.setProgress(0.0f);
            serverBossEvent.setVisible(false);
            serverBossEvent.removeAllPlayers();
            Data.pumpkillagerBossEvents.remove(character);
        }
        if (Util.isPumpkillager((Entity)character)) {
            Manage.resetPlacedBlocks(level, character);
        }
        Manage.yeetLivingEntityIntoSky(level, (LivingEntity)character);
    }
}

