/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_forge.events;

import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.pumpkillagersquest_common_forge.data.Constants;
import com.natamus.pumpkillagersquest_common_forge.util.Util;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class PkSoundEvents {
    public static boolean onSoundEvent(SoundEngine soundEngine, SoundInstance soundInstance) {
        String soundString = soundInstance.getLocation().getPath();
        if (soundString.contains("entity.villager")) {
            BlockPos pos = BlockPos.containing((double)soundInstance.getX(), (double)soundInstance.getY(), (double)soundInstance.getZ());
            for (Entity entity : Constants.mc.level.getEntities(null, new AABB((double)(pos.getX() - 1), (double)(pos.getY() - 1), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)))) {
                if (!Util.isPumpkillager(entity)) continue;
                Villager pumpkillager = (Villager)entity;
                ItemStack headStack = pumpkillager.getItemBySlot(EquipmentSlot.HEAD);
                String headName = headStack.getHoverName().getString();
                SoundEvent soundEvent = SoundEvents.ENDER_DRAGON_GROWL;
                SoundSource soundSource = SoundSource.HOSTILE;
                if (headName.equals("Jack o'Lantern")) {
                    soundEvent = SoundEvents.EVOKER_AMBIENT;
                    soundSource = SoundSource.NEUTRAL;
                }
                SimpleSoundInstance simplesoundinstance = new SimpleSoundInstance(soundEvent, soundSource, 1.0f, (GlobalVariables.randomSource.nextFloat() - GlobalVariables.randomSource.nextFloat()) * 0.2f + 1.0f, GlobalVariables.randomSource, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                soundEngine.play((SoundInstance)simplesoundinstance);
                return false;
            }
        }
        return true;
    }
}

