/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_fabric.pumpkillager;

import com.mojang.datafixers.util.Pair;
import com.natamus.pumpkillagersquest_common_fabric.pumpkillager.Actions;
import com.natamus.pumpkillagersquest_common_fabric.util.Data;
import com.natamus.pumpkillagersquest_common_fabric.util.Scheduler;
import com.natamus.pumpkillagersquest_common_fabric.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_fabric.util.Util;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9334;

public class Conversations {
    public static void startTalking(class_1937 level, class_1646 character, class_1657 targetPlayer, int conversationId) {
        switch (conversationId) {
            case 0: {
                Conversations.startInitialConversation(level, character, targetPlayer);
                break;
            }
            case 1: {
                Conversations.startPostRitualConversation(level, character, targetPlayer);
                break;
            }
            case 2: {
                Conversations.startPostAncientFormConversation(level, character, targetPlayer);
                break;
            }
            case 3: {
                Conversations.startInitialPrisonerShout(level, character, targetPlayer);
                break;
            }
            case 4: {
                Conversations.startPostPrisonerShout(level, character, targetPlayer);
                break;
            }
            case 5: {
                Conversations.startGettingToKnowPrisoner(level, character, targetPlayer);
                break;
            }
            case 6: {
                Conversations.startPrisonerGenerationConversation(level, character, targetPlayer);
                break;
            }
            case 7: {
                Conversations.startInitialFinalBossConversation(level, character, targetPlayer);
                break;
            }
            case 8: {
                Conversations.bossJustGotWeakenedConversation(level, character, targetPlayer);
                break;
            }
            case 9: {
                Conversations.postFinalPrisonerConversation(level, character, targetPlayer);
            }
        }
    }

    public static void startInitialConversation(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer) {
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Hello " + targetPlayer.method_5477().getString() + ".", class_124.field_1068, 0);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "I am the Pumpkillager.", class_124.field_1068, 2000);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "I have a quest for you.", class_124.field_1068, 4000, new class_1799((class_1935)class_1802.field_8360, 1), "hold");
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Right-click the book to accept.", class_124.field_1080, 5000);
    }

    public static void startPostRitualConversation(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer) {
        pumpkillager.method_5752().add("pumpkillagersquest.nodamage");
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 500);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Hehehehehehe.", class_124.field_1080, 510);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Thank you, " + targetPlayer.method_5477().getString() + ".", class_124.field_1068, 3000);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "You have freed me from these shackles.", class_124.field_1068, 5000, SpookyHeads.getEvilJackoLantern(1), "wear");
        Conversations.addMessage(level, pumpkillager, targetPlayer, "My ancient form has been returned.", class_124.field_1068, 6000);
    }

    public static void startPostAncientFormConversation(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer) {
        CompletableFuture.runAsync(() -> {
            class_1799 paperStack = Actions.generatePrisonAndCoordinatePaper(level, pumpkillager, targetPlayer);
            Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
            Conversations.addMessage(level, pumpkillager, targetPlayer, "Are you surprised, mortal?", class_124.field_1068, 10);
            Conversations.addMessage(level, pumpkillager, targetPlayer, "I've been stuck in that tiny form for eons.", class_124.field_1068, 2500);
            Conversations.addMessage(level, pumpkillager, targetPlayer, "Now that I'm free, I can finally continue my quest for world domination.", class_124.field_1068, 5000);
            Conversations.addMessage(level, pumpkillager, targetPlayer, "Goodbye, " + targetPlayer.method_5477().getString() + ". There's no reward, sorry.", class_124.field_1068, 7500);
            Conversations.addMessageWithoutPrefix(level, pumpkillager, targetPlayer, "As the Pumpkillager flies away, you see something fall out of his pocket.", class_124.field_1080, 8490, paperStack, "drop");
            Scheduler.scheduleCharacterLeave(level, pumpkillager, 8500);
        });
    }

    public static void startInitialPrisonerShout(class_1937 level, class_1646 prisoner, class_1657 targetPlayer) {
        if (prisoner.method_5752().contains("pumpkillagersquest.shoutedto." + targetPlayer.method_5477().getString())) {
            return;
        }
        prisoner.method_5752().add("pumpkillagersquest.shoutedto." + targetPlayer.method_5477().getString());
        Conversations.addMessage(level, prisoner, targetPlayer, "Hey, over here!", class_124.field_1068, 0);
        Conversations.addMessage(level, prisoner, targetPlayer, "I'm inside the tree!", class_124.field_1068, 4000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Help me!", class_124.field_1068, 5500);
        Actions.makePrisonerGuardsStepOffHorse(level, prisoner, targetPlayer);
    }

    public static void startPostPrisonerShout(class_1937 level, class_1646 prisoner, class_1657 targetPlayer) {
        String targetPlayerName;
        Set prisonerTags = prisoner.method_5752();
        if (prisonerTags.contains("pumpkillagersquest.isknownto." + (targetPlayerName = targetPlayer.method_5477().getString())) || prisonerTags.contains("pumpkillagersquest.shoutedtotwice." + targetPlayerName)) {
            return;
        }
        Conversations.addMessageWithoutPrefix(level, prisoner, targetPlayer, "Right click the prisoner to talk to him.", class_124.field_1080, 3000);
        prisoner.method_5752().add("pumpkillagersquest.shoutedtotwice." + targetPlayerName);
    }

    public static void startGettingToKnowPrisoner(class_1937 level, class_1646 prisoner, class_1657 targetPlayer) {
        prisoner.method_5752().add("pumpkillagersquest.isknownto." + targetPlayer.method_5477().getString());
        prisoner.method_5752().remove("pumpkillagersquest.persistent");
        prisoner.method_5665((class_2561)class_2561.method_43470((String)"Jax o'Saturn").method_27692(Data.defaultPrisonerColour));
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 0);
        Conversations.addMessage(level, prisoner, targetPlayer, "Hello, my name is Jax o'Saturn.", class_124.field_1068, 10);
        Conversations.addMessage(level, prisoner, targetPlayer, "Did you come here to save me, " + targetPlayer.method_5477().getString() + "?", class_124.field_1068, 4000);
        Conversations.addMessage(level, prisoner, targetPlayer, "I have been locked in here by a creature which called himself the Pumpkillager.", class_124.field_1068, 8000);
        Conversations.addMessage(level, prisoner, targetPlayer, "I've heard stories about this mythical being when I was young, but didn't think he'd be real.", class_124.field_1068, 12000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Never thought I would get out, until I saw you appear through the bars.", class_124.field_1068, 16000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Thanks so much for creating a way out. My magic has disappeared since I've been in here.", class_124.field_1068, 20000);
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 24000);
        Conversations.addMessage(level, prisoner, targetPlayer, "You'll need this book. It contains ancient knowledge on how to stop him. Read it thoroughly.", class_124.field_1068, 24010, Data.getStopPkbook(level), "give");
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 29000);
        Conversations.addMessage(level, prisoner, targetPlayer, "I believe if you follow that ritual, it should summon the Pumpkillager.", class_124.field_1068, 29010);
        Conversations.addMessage(level, prisoner, targetPlayer, "Oh hmm I feel my magic tingle. Let me try something.", class_124.field_1080, 33500);
        Actions.processPrisonerItemGeneration(level, prisoner, targetPlayer, 36000);
    }

    public static void startPrisonerGenerationConversation(class_1937 level, class_1646 prisoner, class_1657 targetPlayer) {
        class_1799 bowStack = new class_1799((class_1935)class_1802.field_8102, 1);
        bowStack.method_7978((class_6880)level.method_30349().method_30530(class_7924.field_41265).method_40290(class_1893.field_9103), 3);
        class_1799 arrowStack = new class_1799((class_1935)class_1802.field_8236, 4);
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 1500);
        Conversations.addMessage(level, prisoner, targetPlayer, "My magic is coming back, thank Notch.", class_124.field_1080, 1510);
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 4000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Take these arrows, you'll need them to defeat the Pumpkillager.", class_124.field_1068, 4010, arrowStack, "give");
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 8000);
        Conversations.addMessage(level, prisoner, targetPlayer, "This bow will probably come in useful too.", class_124.field_1068, 8010, bowStack, "give");
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 12000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Now be quick, before it's too late. Perform the reversed ritual from the book, and destroy that creature once and for all.", class_124.field_1068, 12010);
        Conversations.addMessage(level, prisoner, targetPlayer, "You are going to need candles for the ritual. There should be some around here on the island.", class_124.field_1068, 16000);
        Conversations.addMessage(level, prisoner, targetPlayer, "I'll be there too when you summon the Pumpkillager. Good bye, and thanks again!", class_124.field_1068, 20000);
        Scheduler.scheduleCharacterLeave(level, prisoner, 22500);
        targetPlayer.method_5752().add("pumpkillagersquest.cansummonfinalform");
    }

    public static void startInitialFinalBossConversation(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer) {
        pumpkillager.method_5702(class_2183.class_2184.field_9851, targetPlayer.method_19538());
        String suffixa = "";
        String suffixb = "";
        if (targetPlayer.method_5752().contains("pumpkillagersquest.diedonce")) {
            suffixa = " AGAIN";
            suffixb = " still";
        }
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Huh.. how did I get here.", class_124.field_1080, 10);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "YOU" + suffixa + "!", class_124.field_1068, 2500);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "I" + suffixb + " don't know how you managed to complete this ritual correctly, but you're going to regret it.", class_124.field_1068, 4500);
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 8500);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "FEEL MY WRATH", class_124.field_1068, 8510);
        Scheduler.scheduleMinionSummoning(level, pumpkillager, targetPlayer, 0, 9000);
    }

    public static void bossJustGotWeakenedConversation(class_1937 level, class_1646 pumpkillager, class_1657 targetPlayer) {
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 50);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "AAAAGHHHHHH", class_124.field_1065, 60);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "It hurts! What did you do to me?", class_124.field_1068, 1000);
    }

    public static void postFinalPrisonerConversation(class_1937 level, class_1646 prisoner, class_1657 targetPlayer) {
        class_2378 enchantmentsRegistry = level.method_30349().method_30530(class_7924.field_41265);
        class_1799 rewardStack = new class_1799((class_1935)class_1802.field_22022, 1);
        rewardStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Pumpkalibur").method_27692(class_124.field_1065));
        rewardStack.method_7978((class_6880)enchantmentsRegistry.method_40290(class_1893.field_9118), 4);
        rewardStack.method_7978((class_6880)enchantmentsRegistry.method_40290(class_1893.field_9115), 3);
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 0);
        Conversations.addMessage(level, prisoner, targetPlayer, "You did it, " + targetPlayer.method_5477().getString() + "!", class_124.field_1068, 500);
        Conversations.addMessage(level, prisoner, targetPlayer, "With the Pumpkillager defeated, the world has lost its most dangerous threat.", class_124.field_1068, 4500);
        Conversations.addMessage(level, prisoner, targetPlayer, "Take this, you've earned it.", class_124.field_1068, 8500, rewardStack, "give");
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 12500);
        Conversations.addMessage(level, prisoner, targetPlayer, "The citizens of this world will not forget this.", class_124.field_1068, 12510);
        Conversations.addMessage(level, prisoner, targetPlayer, "Thank you.", class_124.field_1068, 16500);
        Scheduler.scheduleCharacterLeave(level, prisoner, 18000);
    }

    public static void addMessage(class_1937 level, class_1646 character, class_1657 player, class_5250 messageComponent, int msDelay) {
        Conversations.addMessage(level, character, player, messageComponent, msDelay, null, "");
    }

    public static void addMessage(class_1937 level, class_1646 character, class_1657 player, class_5250 messageComponent, int msDelay, class_1799 itemStack, String itemStackBehaviour) {
        Conversations.addMessage(level, character, (Pair<class_1657, class_5250>)new Pair((Object)player, (Object)messageComponent), msDelay, itemStack, itemStackBehaviour);
    }

    public static void addMessage(class_1937 level, class_1646 character, class_1657 player, String message, class_124 colour, int msDelay) {
        Conversations.addMessage(level, character, player, message, colour, msDelay, null, "");
    }

    public static void addMessage(class_1937 level, class_1646 character, class_1657 player, String message, class_124 colour, int msDelay, class_1799 itemStack, String itemStackBehaviour) {
        Conversations.addMessage(level, character, Conversations.createMessagePair(player, message, colour), msDelay, itemStack, itemStackBehaviour);
    }

    public static void addMessage(class_1937 level, class_1646 character, Pair<class_1657, class_5250> messagePair, int msDelay) {
        Conversations.addMessage(level, character, messagePair, msDelay, null, "");
    }

    public static void addMessage(class_1937 level, class_1646 character, Pair<class_1657, class_5250> messagePair, int msDelay, class_1799 itemStack, String itemStackBehaviour) {
        if (character != null && character.method_5752().contains("pumpkillagersquest.iskilled")) {
            return;
        }
        if (msDelay == 0) {
            Data.messagesToSend.get(level).add(Util.modifyMessagePair(messagePair, Data.addCharacterPrefix(character, (class_1657)messagePair.getFirst(), (class_5250)messagePair.getSecond())));
            return;
        }
        Scheduler.scheduleCharacterMessage(level, character, Util.modifyMessagePair(messagePair, Data.addCharacterPrefix(character, (class_1657)messagePair.getFirst(), (class_5250)messagePair.getSecond())), msDelay, itemStack, itemStackBehaviour);
    }

    public static void addPostDeathMessage(class_1937 level, class_1646 character, class_1657 player, String message, class_124 colour) {
        if (message.equals("")) {
            Data.messagesToSend.get(level).add(Conversations.createMessagePair(player, message));
            return;
        }
        Conversations.addPostDeathMessage(level, character, Conversations.createMessagePair(player, message, colour));
    }

    public static void addPostDeathMessage(class_1937 level, class_1646 character, Pair<class_1657, class_5250> messagePair) {
        Data.messagesToSend.get(level).add(Util.modifyMessagePair(messagePair, Data.addCharacterPrefix(character, (class_1657)messagePair.getFirst(), (class_5250)messagePair.getSecond())));
    }

    public static void addEmptyMessage(class_1937 level, class_1646 character, class_1657 player, int msDelay) {
        Conversations.addMessageWithoutPrefix(level, character, player, "", class_124.field_1068, msDelay);
    }

    public static void addMessageWithoutPrefix(class_1937 level, class_1646 character, class_1657 player, String messageString, class_124 colour, int msDelay) {
        Conversations.addMessageWithoutPrefix(level, character, player, messageString, colour, msDelay, null, "");
    }

    public static void addMessageWithoutPrefix(class_1937 level, class_1646 character, class_1657 player, class_5250 component, int msDelay) {
        Conversations.addMessageWithoutPrefix(level, character, player, component, msDelay, null, "");
    }

    public static void addMessageWithoutPrefix(class_1937 level, class_1646 character, class_1657 player, String messageString, class_124 colour, int msDelay, class_1799 itemStack, String itemStackBehaviour) {
        Pair<class_1657, class_5250> messagePair = Conversations.createMessagePair(player, messageString, colour);
        if (character != null && character.method_5752().contains("pumpkillagersquest.iskilled")) {
            return;
        }
        if (msDelay == 0) {
            Data.messagesToSend.get(level).add(messagePair);
            return;
        }
        Scheduler.scheduleCharacterMessage(level, character, messagePair, msDelay, itemStack, itemStackBehaviour);
    }

    public static void addMessageWithoutPrefix(class_1937 level, class_1646 character, class_1657 player, class_5250 component, int msDelay, class_1799 itemStack, String itemStackBehaviour) {
        Pair<class_1657, class_5250> messagePair = Conversations.createMessagePair(player, component);
        if (character != null && character.method_5752().contains("pumpkillagersquest.iskilled")) {
            return;
        }
        if (msDelay == 0) {
            Data.messagesToSend.get(level).add(messagePair);
            return;
        }
        Scheduler.scheduleCharacterMessage(level, character, messagePair, msDelay, itemStack, itemStackBehaviour);
    }

    public static void sendJaxMessage(class_1937 level, class_1657 player, String message, class_124 colour, int msDelay) {
        Conversations.sendJaxMessage(level, player, message, colour, msDelay, null, "");
    }

    public static void sendJaxMessage(class_1937 level, class_1657 player, String message, class_124 colour, int msDelay, class_1799 itemStack, String itemStackBehaviour) {
        Conversations.addMessageWithoutPrefix(level, null, player, Data.addCharacterPrefix("knownprisoner", player, class_2561.method_43471((String)message).method_27692(colour)), msDelay, itemStack, itemStackBehaviour);
    }

    public static Pair<class_1657, class_5250> createMessagePair(class_1657 player, String message, class_124 colour) {
        return new Pair((Object)player, (Object)class_2561.method_43471((String)message).method_27692(colour));
    }

    public static Pair<class_1657, class_5250> createMessagePair(class_1657 player, class_5250 component) {
        return new Pair((Object)player, (Object)component);
    }

    public static Pair<class_1657, class_5250> createMessagePair(class_1657 player, String messageString) {
        return new Pair((Object)player, (Object)class_2561.method_43471((String)messageString));
    }
}

