/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.core;

import com.mojang.logging.LogUtils;
import dev.orderedchaos.projectvibrantjourneys.common.PVJFlammables;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.ruinednetherportal.RuinedPortalDecoratorBase;
import dev.orderedchaos.projectvibrantjourneys.core.PVJConfig;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBiomeModifiers;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBlocks;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJConfiguredFeatures;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJCreativeTabs;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJFeatures;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJItems;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJMobEffects;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJPlacementModifiers;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJPlacements;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJPotions;
import dev.orderedchaos.projectvibrantjourneys.data.client.PVJLanguageProvider;
import dev.orderedchaos.projectvibrantjourneys.data.datamaps.PVJDataMapsProvider;
import dev.orderedchaos.projectvibrantjourneys.data.loottables.PVJBlockLoot;
import dev.orderedchaos.projectvibrantjourneys.data.recipes.PVJRecipes;
import dev.orderedchaos.projectvibrantjourneys.data.tags.PVJBiomeTagsProvider;
import dev.orderedchaos.projectvibrantjourneys.data.tags.PVJBlockTagsProvider;
import dev.orderedchaos.projectvibrantjourneys.data.tags.PVJItemTagsProvider;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.slf4j.Logger;

@Mod(value="projectvibrantjourneys")
public class ProjectVibrantJourneys {
    public static final String MOD_ID = "projectvibrantjourneys";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ProjectVibrantJourneys(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        PVJItems.ITEMS.register(modEventBus);
        PVJBlocks.BLOCKS.register(modEventBus);
        PVJFeatures.FEATURES.register(modEventBus);
        PVJFeatures.StateProviders.TYPES.register(modEventBus);
        PVJBiomeModifiers.BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        PVJConfiguredFeatures.CONFIGURED_FEATURES.register(modEventBus);
        PVJPlacementModifiers.PLACEMENT_MODIFIERS.register(modEventBus);
        PVJMobEffects.MOB_EFFECTS.register(modEventBus);
        PVJPotions.POTIONS.register(modEventBus);
        PVJCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PVJConfig.COMMON_CONFIG);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RuinedPortalDecoratorBase.registerPortalDecorators();
            PVJFlammables.bootstrap();
        });
    }

    @EventBusSubscriber(modid="projectvibrantjourneys", bus=EventBusSubscriber.Bus.MOD)
    public static class Data {
        private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.CONFIGURED_FEATURE, PVJConfiguredFeatures::bootstrap).add(Registries.PLACED_FEATURE, PVJPlacements::bootstrap).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, PVJBiomeModifiers::bootstrap);

        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = event.getGenerator().getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            PVJBlockTagsProvider blockTagsProvider = new PVJBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
            generator.addProvider(event.includeServer(), (DataProvider)new PVJItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
            generator.addProvider(event.includeServer(), (DataProvider)new PVJBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
            generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(PVJBlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, BUILDER, Set.of(ProjectVibrantJourneys.MOD_ID)));
            generator.addProvider(event.includeServer(), (DataProvider)new PVJRecipes(packOutput, lookupProvider));
            generator.addProvider(event.includeServer(), (DataProvider)new PVJDataMapsProvider(packOutput, lookupProvider));
            generator.addProvider(event.includeClient(), (DataProvider)new PVJLanguageProvider(packOutput));
        }
    }
}

