/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.modifiers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import dev.orderedchaos.projectvibrantjourneys.core.PVJConfig;
import dev.orderedchaos.projectvibrantjourneys.core.registry.PVJBiomeModifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record PVJBiomeModifier(TagKey<Biome> dimension, List<HolderSet<Biome>> biomes, List<HolderSet<Biome>> blacklist, GenerationStep.Decoration decoration, Holder<PlacedFeature> feature, String configOption) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        Pair<ModConfigSpec.BooleanValue, Optional<ModConfigSpec.DoubleValue>> configValuePair = PVJConfig.configOptions.get(this.configOption);
        boolean enabled = (Boolean)((ModConfigSpec.BooleanValue)configValuePair.getFirst()).get();
        if (!enabled) {
            return;
        }
        if (!((Boolean)((ModConfigSpec.BooleanValue)configValuePair.getFirst()).get()).booleanValue()) {
            return;
        }
        if (phase == BiomeModifier.Phase.AFTER_EVERYTHING && biome.is(this.dimension)) {
            boolean flag = false;
            for (HolderSet<Biome> set : this.biomes) {
                if (!set.contains(biome)) continue;
                flag = true;
                break;
            }
            if (flag) {
                for (HolderSet<Biome> set : this.blacklist) {
                    if (!set.contains(biome)) continue;
                    return;
                }
                builder.getGenerationSettings().addFeature(this.decoration, this.feature);
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)PVJBiomeModifiers.BIOME_MODIFIER_SERIALIZER.get();
    }

    public static class Builder {
        private HolderGetter<PlacedFeature> placedFeatureGetter;
        private HolderGetter<Biome> biomeGetter;
        private TagKey<Biome> dimension = BiomeTags.IS_OVERWORLD;
        private HolderSet.Named<Biome> namedTags;
        private List<TagKey<Biome>> biomeTags = new ArrayList<TagKey<Biome>>();
        private List<TagKey<Biome>> blacklistTags = new ArrayList<TagKey<Biome>>();
        private List<Holder<Biome>> extraBiomes = new ArrayList<Holder<Biome>>();
        private List<Holder<Biome>> extraBlacklist = new ArrayList<Holder<Biome>>();
        private GenerationStep.Decoration decoration = GenerationStep.Decoration.VEGETAL_DECORATION;
        private final String configOption;
        private ResourceKey<PlacedFeature> placedFeatureKey;

        public Builder(BootstrapContext<BiomeModifier> context, String configOption) {
            this.placedFeatureGetter = context.lookup(Registries.PLACED_FEATURE);
            this.biomeGetter = context.lookup(Registries.BIOME);
            this.configOption = configOption;
        }

        public Builder placedFeature(ResourceKey<PlacedFeature> placedFeatureKey) {
            this.placedFeatureKey = placedFeatureKey;
            return this;
        }

        public Builder dimension(Dimension dim) {
            TagKey tagKey = BiomeTags.IS_OVERWORLD;
            switch (dim.ordinal()) {
                case 1: {
                    tagKey = BiomeTags.IS_NETHER;
                    break;
                }
                case 2: {
                    tagKey = BiomeTags.IS_END;
                }
            }
            this.dimension = tagKey;
            return this;
        }

        public Builder decoration(GenerationStep.Decoration decoration) {
            this.decoration = decoration;
            return this;
        }

        public Builder tag(List<TagKey<Biome>> tags) {
            this.biomeTags.addAll(this.combine(tags));
            return this;
        }

        public Builder blacklist(List<TagKey<Biome>> ... tags) {
            this.blacklistTags.addAll(this.combine(tags));
            return this;
        }

        public Builder extraBiomes(List<Holder<Biome>> ... biomes) {
            this.extraBiomes.addAll(this.combine(biomes));
            return this;
        }

        public Builder extraBiomes(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                Holder.Reference biomeHolder = this.biomeGetter.getOrThrow(biome);
                this.extraBiomes.add((Holder<Biome>)biomeHolder);
            }
            return this;
        }

        public Builder biomes(HolderSet.Named<Biome> holders) {
            this.namedTags = holders;
            return this;
        }

        public Builder extraBlacklist(List<Holder<Biome>> ... biomes) {
            this.extraBlacklist.addAll(this.combine(biomes));
            return this;
        }

        public Builder extraBlacklist(ResourceKey<Biome> ... biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                Holder.Reference biomeHolder = this.biomeGetter.getOrThrow(biome);
                this.extraBlacklist.add((Holder<Biome>)biomeHolder);
            }
            return this;
        }

        public Builder extraBlacklist(List<ResourceKey<Biome>> biomes) {
            for (ResourceKey<Biome> biome : biomes) {
                Holder.Reference biomeHolder = this.biomeGetter.getOrThrow(biome);
                this.extraBlacklist.add((Holder<Biome>)biomeHolder);
            }
            return this;
        }

        @SafeVarargs
        public final <T> List<T> combine(List<T> ... lists) {
            ArrayList<T> list = new ArrayList<T>();
            for (List<T> i : lists) {
                for (T tag : i) {
                    list.add(tag);
                }
            }
            return list;
        }

        public PVJBiomeModifier build() {
            ArrayList<HolderSet.Named> biomesSet = new ArrayList<HolderSet.Named>(this.biomeTags.stream().map(tag -> this.biomeGetter.getOrThrow(tag)).toList());
            ArrayList<HolderSet.Named> blacklistSet = new ArrayList<HolderSet.Named>(this.blacklistTags.stream().map(tag -> this.biomeGetter.getOrThrow(tag)).toList());
            if (!this.extraBiomes.isEmpty()) {
                biomesSet.add((HolderSet.Named)HolderSet.direct(this.extraBiomes));
            }
            if (this.namedTags != null) {
                biomesSet.add(this.namedTags);
            }
            if (!this.extraBlacklist.isEmpty()) {
                blacklistSet.add((HolderSet.Named)HolderSet.direct(this.extraBlacklist));
            }
            Holder.Reference placedFeature = this.placedFeatureGetter.getOrThrow(this.placedFeatureKey);
            return new PVJBiomeModifier(this.dimension, biomesSet, blacklistSet, this.decoration, (Holder<PlacedFeature>)placedFeature, this.configOption);
        }

        public static enum Dimension {
            OVERWORLD,
            NETHER,
            END;

        }
    }
}

