/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.BarkMushroomBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.FallenLeavesBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.GroundcoverBlock;
import dev.orderedchaos.projectvibrantjourneys.common.blocks.HollowLogBlock;
import dev.orderedchaos.projectvibrantjourneys.common.world.features.configurations.FallenTreeConfiguration;
import dev.orderedchaos.projectvibrantjourneys.core.PVJConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ModConfigSpec;

public class FallenTreeFeature
extends Feature<FallenTreeConfiguration> {
    public FallenTreeFeature(Codec<FallenTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FallenTreeConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        BlockState hollowLog = ((FallenTreeConfiguration)context.config()).hollowLog();
        BlockState baseLog = ((FallenTreeConfiguration)context.config()).baseLog();
        if (rand.nextFloat() > 0.1f) {
            return false;
        }
        BlockState below = level.getBlockState(pos.below());
        if (below.is(BlockTags.ICE) || below.getBlock() == Blocks.SNOW_BLOCK || below.getFluidState().isSource()) {
            return false;
        }
        int length = rand.nextInt(3) + 4;
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(rand);
        Direction dirCounterClockwise = dir.getCounterClockWise();
        Direction dirClockwise = dir.getClockWise();
        boolean branched = false;
        for (int i = 0; i < length; ++i) {
            if (!this.canReplace(level, pos)) {
                return false;
            }
            pos = pos.offset(dir.getNormal());
        }
        pos = context.origin();
        List<FallenTreeConfiguration.FallenTreeVegetation> vegetationProviders = ((FallenTreeConfiguration)context.config()).vegetationProviders();
        RandomSource randomSource = level.getRandom();
        for (int i = 0; i < length; ++i) {
            if (this.canReplace(level, pos)) {
                if (!below.canBeReplaced() && !below.getFluidState().is((Fluid)Fluids.WATER) || i > length / 2) {
                    BarkMushroomBlock mushroom;
                    BlockState state;
                    boolean mossy = ((FallenTreeConfiguration)context.config()).canBeMossy() ? randomSource.nextBoolean() : false;
                    level.setBlock(pos, (BlockState)((BlockState)hollowLog.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis())).setValue((Property)HollowLogBlock.MOSSY, (Comparable)Boolean.valueOf(mossy)), 2);
                    if (level.isEmptyBlock(pos.above()) && rand.nextFloat() < 0.75f) {
                        level.setBlock(pos.above(), this.getVegetationToPlace(vegetationProviders, randomSource, pos.above()), 2);
                    }
                    if (!branched && i <= length / 2 + 1 && rand.nextFloat() < 0.5f) {
                        BlockPos branchPos = rand.nextBoolean() ? pos.offset(dirCounterClockwise.getNormal()) : pos.offset(dirClockwise.getNormal());
                        level.setBlock(branchPos, (BlockState)baseLog.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dirCounterClockwise.getAxis()), 2);
                        if (level.isEmptyBlock(branchPos.above()) && rand.nextFloat() < 0.4f) {
                            level.setBlock(branchPos.above(), this.getVegetationToPlace(vegetationProviders, randomSource, branchPos.above()), 2);
                        }
                        branched = true;
                    }
                    BlockPos original = pos;
                    boolean shouldHaveBarkMushrooms = (Boolean)((ModConfigSpec.BooleanValue)PVJConfig.configOptions.get("enableBarkMushrooms").getFirst()).get();
                    if (this.canReplace(level, pos = pos.offset(dirCounterClockwise.getNormal()))) {
                        if (rand.nextFloat() < 0.4f && Block.isFaceFull((VoxelShape)level.getBlockState(pos.below()).getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP)) {
                            state = this.getVegetationToPlace(vegetationProviders, randomSource, pos);
                            if (state.canSurvive((LevelReader)level, pos)) {
                                level.setBlock(pos, state, 2);
                            }
                        } else if (rand.nextFloat() < 0.4f && shouldHaveBarkMushrooms) {
                            mushroom = BarkMushroomBlock.getRandom(rand);
                            level.setBlock(pos, (BlockState)mushroom.defaultBlockState().setValue((Property)BarkMushroomBlock.FACING, (Comparable)dirCounterClockwise), 2);
                        }
                    }
                    pos = original;
                    if (this.canReplace(level, pos = pos.offset(dirClockwise.getNormal()))) {
                        if (rand.nextFloat() < 0.4f && Block.isFaceFull((VoxelShape)level.getBlockState(pos.below()).getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP)) {
                            state = this.getVegetationToPlace(vegetationProviders, randomSource, pos);
                            if (state.canSurvive((LevelReader)level, pos)) {
                                level.setBlock(pos, state, 2);
                            }
                        } else if (rand.nextFloat() < 0.4f && shouldHaveBarkMushrooms) {
                            mushroom = BarkMushroomBlock.getRandom(rand);
                            level.setBlock(pos, (BlockState)mushroom.defaultBlockState().setValue((Property)BarkMushroomBlock.FACING, (Comparable)dirClockwise), 2);
                        }
                    }
                    pos = original;
                    pos = pos.offset(dir.getNormal());
                } else {
                    dir = dir.getOpposite();
                    pos = context.origin().offset(dir.getNormal());
                }
            } else {
                return length - i < length;
            }
            below = level.getBlockState(pos.below());
        }
        return true;
    }

    public boolean canReplace(WorldGenLevel world, BlockPos pos) {
        return world.getBlockState(pos).canBeReplaced() || world.isEmptyBlock(pos) || world.getBlockState(pos).getBlock() instanceof FallenLeavesBlock || world.getBlockState(pos).getBlock() instanceof GroundcoverBlock;
    }

    private BlockState getVegetationToPlace(List<FallenTreeConfiguration.FallenTreeVegetation> vegetationProviders, RandomSource randomSource, BlockPos pos) {
        int numProviders = vegetationProviders.size();
        FallenTreeConfiguration.FallenTreeVegetation vegetation = null;
        while (vegetation == null) {
            String configOption;
            int random = randomSource.nextInt(numProviders);
            FallenTreeConfiguration.FallenTreeVegetation temp = vegetationProviders.get(random);
            if (temp.configOption().isPresent() && !((Boolean)((ModConfigSpec.BooleanValue)PVJConfig.configOptions.get(configOption = temp.configOption().get()).getFirst()).get()).booleanValue()) continue;
            vegetation = temp;
        }
        return vegetation.provider().getState(randomSource, pos);
    }
}

