/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;

public class DoubleHighWaterPlantBlock
extends DoublePlantBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private boolean allowAdjacentToWater;

    public DoubleHighWaterPlantBlock(BlockBehaviour.Properties props, boolean allowAdjacentToWater) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.allowAdjacentToWater = allowAdjacentToWater;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            return false;
        }
        if (state.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            BlockPos groundPos = pos.below();
            BlockState ground = level.getBlockState(groundPos);
            if (level.getFluidState(pos).getType() == Fluids.WATER) {
                return this.canGrow(level, groundPos, Direction.UP, ground);
            }
            if (this.allowAdjacentToWater) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (level.getFluidState(groundPos.offset(direction.getNormal())).getType() != Fluids.WATER) continue;
                    return this.canGrow(level, groundPos, Direction.UP, ground);
                }
            }
            return false;
        }
        BlockState blockstate = level.getBlockState(pos.below());
        if (state.getBlock() != this) {
            return false;
        }
        return blockstate.getBlock() == this && blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public boolean canGrow(LevelReader level, BlockPos pos, Direction dir, BlockState ground) {
        TriState soilDecision = ground.canSustainPlant((BlockGetter)level, pos.below(), Direction.UP, this.defaultBlockState());
        if (!soilDecision.isDefault()) {
            return soilDecision.isTrue();
        }
        return ground.is(BlockTags.DIRT) || ground.is(BlockTags.SAND) || ground.is(Tags.Blocks.GRAVELS) || ground.is(Tags.Blocks.SANDS) || ground.is(Blocks.CLAY) || ground.is(BlockTags.BIG_DRIPLEAF_PLACEABLE);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState stateUpper;
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                world.setBlock(pos, Blocks.WATER.defaultBlockState(), 2);
            } else {
                world.destroyBlock(pos, false);
            }
        }
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && (stateUpper = world.getBlockState(pos.above())).getBlock() instanceof DoubleHighWaterPlantBlock && !this.canSurvive(stateUpper, (LevelReader)world, pos.above())) {
            world.destroyBlock(pos.above(), false);
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, WATERLOGGED});
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return true;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        DoubleHighWaterPlantBlock.popResource((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
    }
}

