/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.util;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivelib.util.ColorUtil;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveLeavesBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveSaplingBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveWoodBlock;
import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.StripperBlockEntity;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;

public class TreeUtil {
    public static final UUID STRIPPER_UUID = UUID.nameUUIDFromBytes("pt_stripper".getBytes(StandardCharsets.UTF_8));
    static Map<String, RecipeHolder<SawmillRecipe>> sawmillRecipeCache = new HashMap<String, RecipeHolder<SawmillRecipe>>();

    private static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "productivetrees", pathName);
        TreeUtil.createDirectory(customPath, pathName);
        return customPath;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Path createModPath(String pathName) {
        List<Path> roots = List.of(ModList.get().getModFileById("productivetrees").getFile().getFilePath());
        for (Path modRoot : roots) {
            if (Files.isRegularFile(modRoot, new LinkOption[0])) {
                try (FileSystem fileSystem = FileSystems.newFileSystem(modRoot);){
                    Path path2 = fileSystem.getPath(pathName, new String[0]);
                    if (!Files.exists(path2, new LinkOption[0])) continue;
                    Path path = path2;
                    return path;
                }
                catch (IOException e) {
                    ProductiveTrees.LOGGER.error("Could not load source {}!!", (Object)modRoot);
                    e.printStackTrace();
                }
                continue;
            }
            if (!Files.isDirectory(modRoot, new LinkOption[0])) continue;
            return modRoot;
        }
        return null;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            ProductiveTrees.LOGGER.error("failed to create \"" + dirName + "\" directory");
        }
    }

    public static int getLeafColor(Block leaf) {
        return TreeUtil.getLeafColor(leaf, null, null);
    }

    public static int getLeafColor(Block leaf, BlockAndTintGetter lightReader, BlockPos pos) {
        if (leaf != null) {
            if (leaf instanceof ProductiveLeavesBlock) {
                ProductiveLeavesBlock leafBlock = (ProductiveLeavesBlock)leaf;
                return ColorUtil.getCacheColor((String)leafBlock.getTree().getLeafColor());
            }
            if (leaf.equals(Blocks.SPRUCE_LEAVES)) {
                return FoliageColor.getEvergreenColor();
            }
            if (leaf.equals(Blocks.BIRCH_LEAVES)) {
                return FoliageColor.getBirchColor();
            }
        }
        if (lightReader != null && pos != null) {
            return BiomeColors.getAverageFoliageColor((BlockAndTintGetter)lightReader, (BlockPos)pos);
        }
        return FoliageColor.getDefaultColor();
    }

    public static ItemStack getLeafFromSapling(ItemStack saplingStack) {
        ProductiveSaplingBlock saplingBlock;
        TreeObject tree;
        BlockItem blockItem;
        Item item = saplingStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof ProductiveSaplingBlock && (tree = TreeUtil.getTree((Block)(saplingBlock = (ProductiveSaplingBlock)item))) != null) {
            return new ItemStack((ItemLike)TreeUtil.getBlock(tree.getId(), "_leaves"));
        }
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)saplingStack.getItem());
        if (resourceLocation != null) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation.withPath(p -> p.replace("_sapling", "_propagule").replace("_sapling", "_leaves")));
            if (block.equals(Blocks.AIR)) {
                block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation.withPath(p -> p + "_leaves"));
            }
            if (block != null) {
                return new ItemStack((ItemLike)block);
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getSaplingFromLeaf(ItemStack leafStack) {
        ProductiveLeavesBlock leavesBlock;
        TreeObject tree;
        BlockItem blockItem;
        Item item = leafStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof ProductiveLeavesBlock && (tree = TreeUtil.getTree((Block)(leavesBlock = (ProductiveLeavesBlock)item))) != null) {
            return new ItemStack((ItemLike)TreeUtil.getBlock(tree.getId(), "_sapling"));
        }
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)leafStack.getItem());
        if (resourceLocation != null) {
            Block block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation.withPath(p -> p.replace("_leaves", "_sapling")));
            if (block.equals(Blocks.AIR)) {
                block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation.withPath(p -> p.replace("_leaves", "_propagule")));
            }
            if (block.equals(Blocks.AIR)) {
                block = (Block)BuiltInRegistries.BLOCK.get(resourceLocation.withPath(p -> p.replace("_leaves", "")));
            }
            if (block != null) {
                return new ItemStack((ItemLike)block);
            }
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getStrippedItem(StripperBlockEntity blockEntity, ServerLevel level, ItemStack stack) {
        Item item;
        ItemStack stripped = TreeUtil.getStrippedItem(stack);
        if (stripped.isEmpty() && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState initialState = blockItem.getBlock().defaultBlockState();
            BlockState stripState = AxeItem.getAxeStrippingState((BlockState)initialState);
            return stripState != null && !stripState.equals(initialState) ? new ItemStack((ItemLike)initialState.getBlock()) : ItemStack.EMPTY;
        }
        return stripped;
    }

    public static ItemStack getStrippedItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            ProductiveWoodBlock pWood;
            ProductiveLogBlock pLog;
            Object tree;
            BlockItem blockItem = (BlockItem)item;
            BlockState initialState = blockItem.getBlock().defaultBlockState();
            BlockState stripState = AxeItem.getAxeStrippingState((BlockState)initialState);
            if (stripState != null) {
                return new ItemStack((ItemLike)stripState.getBlock());
            }
            Block block = initialState.getBlock();
            if (block instanceof ProductiveLogBlock && (tree = TreeUtil.getTree((Block)(pLog = (ProductiveLogBlock)block))) != null) {
                return new ItemStack((ItemLike)TreeUtil.getBlock(((WoodObject)tree).getId(), "_stripped_log"));
            }
            tree = initialState.getBlock();
            if (tree instanceof ProductiveWoodBlock && (tree = TreeUtil.getTree((Block)(pWood = (ProductiveWoodBlock)((Object)tree)))) != null) {
                return new ItemStack((ItemLike)TreeUtil.getBlock(((WoodObject)tree).getId(), "_stripped_wood"));
            }
        }
        return ItemStack.EMPTY;
    }

    public static RecipeHolder<SawmillRecipe> getSawmillRecipe(Level level, ItemStack stack) {
        if (!stack.isEmpty()) {
            String cacheItem = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString() + String.valueOf(!stack.getComponents().isEmpty() ? stack.getComponents().stream().map(TypedDataComponent::toString).reduce((s, s2) -> s + s2) : "");
            if (sawmillRecipeCache.containsKey(cacheItem)) {
                return sawmillRecipeCache.get(cacheItem);
            }
            List recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)TreeRegistrator.SAW_MILLLING_TYPE.get());
            for (RecipeHolder recipe : recipes) {
                if (!((SawmillRecipe)recipe.value()).input().test(stack)) continue;
                sawmillRecipeCache.put(cacheItem, (RecipeHolder<SawmillRecipe>)recipe);
                return recipe;
            }
        }
        return null;
    }

    public static ItemStack getPollen(Block block) {
        ItemStack pollenStack = new ItemStack((ItemLike)TreeRegistrator.POLLEN.get());
        pollenStack.set(TreeRegistrator.POLLEN_BLOCK_COMPONENT, (Object)BuiltInRegistries.BLOCK.getKey((Object)block));
        return pollenStack;
    }

    public static boolean isSpecialTree(ResourceLocation id) {
        return id.getPath().equals("purple_spiral") || id.getPath().equals("cave_dweller") || id.getPath().equals("black_ember") || id.getPath().equals("brown_amber") || id.getPath().equals("firecracker") || id.getPath().equals("flickering_sun") || id.getPath().equals("foggy_blast") || id.getPath().equals("night_fuchsia") || id.getPath().equals("time_traveller") || id.getPath().equals("rippling_willow") || id.getPath().equals("soul_tree") || id.getPath().equals("sparkle_cherry") || id.getPath().equals("slimy_delight") || id.getPath().equals("thunder_bolt") || id.getPath().equals("blue_yonder") || id.getPath().equals("water_wonder");
    }

    public static boolean isTranslucentTree(String name) {
        return name.equals("brown_amber") || name.equals("slimy_delight") || name.equals("foggy_blast") || name.equals("soul_tree") || name.equals("water_wonder");
    }

    public static Block getBlock(ResourceLocation tree, String name) {
        return (Block)BuiltInRegistries.BLOCK.get(tree.withPath(p -> p + name));
    }

    public static TreeObject getTree(Block block) {
        return TreeFinder.trees.get(BuiltInRegistries.BLOCK.getKey((Object)block).withPath(p -> p.replace("_log", "").replace("_wood", "").replace("_sapling", "").replace("_leaves", "")));
    }

    public static void pollinateLeaves(Level level, BlockPos pos, int distance, boolean isSpecialPollinator, List<BlockState> uniqueLeaves) {
        List<BlockPos> leaves = BlockPos.betweenClosedStream((BlockPos)pos.offset(-distance, -distance, -distance), (BlockPos)pos.offset(distance, distance, distance)).map(BlockPos::immutable).toList();
        HashMap leafMap = new HashMap();
        leaves.forEach(blockPos -> {
            BlockState state = level.getBlockState(blockPos);
            if (state.is(ModTags.POLLINATABLE) && !state.is((Block)TreeRegistrator.POLLINATED_LEAVES.get()) && !(state.getBlock() instanceof ProductiveFruitBlock)) {
                leafMap.put(state, blockPos);
                if (!uniqueLeaves.contains(state)) {
                    uniqueLeaves.add(state);
                }
            }
        });
        if (!uniqueLeaves.isEmpty()) {
            HashMap matchedRecipes = new HashMap();
            List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)TreeRegistrator.TREE_POLLINATION_TYPE.get());
            allRecipes.forEach(treePollinationRecipe -> {
                if (!matchedRecipes.containsKey(treePollinationRecipe)) {
                    uniqueLeaves.forEach(stateA -> uniqueLeaves.forEach(stateB -> {
                        if (((TreePollinationRecipe)treePollinationRecipe.value()).matches((BlockState)stateA, (BlockState)stateB)) {
                            matchedRecipes.put(treePollinationRecipe, Pair.of((Object)stateA, (Object)stateB));
                        }
                    }));
                }
            });
            if (!matchedRecipes.isEmpty()) {
                RecipeHolder pickedRecipe = (RecipeHolder)matchedRecipes.keySet().toArray()[level.random.nextInt(matchedRecipes.size())];
                Pair states = (Pair)matchedRecipes.get(pickedRecipe);
                BlockPos posA = level.random.nextBoolean() ? (BlockPos)leafMap.get(states.getFirst()) : (BlockPos)leafMap.get(states.getSecond());
                float f = level.random.nextFloat();
                float f2 = ((TreePollinationRecipe)pickedRecipe.value()).chance;
                int n = isSpecialPollinator ? 5 : 1;
                if (f <= f2 * (float)n && level.getBlockState(posA).is(BlockTags.LEAVES)) {
                    level.setBlock(posA, ((Block)TreeRegistrator.POLLINATED_LEAVES.get()).defaultBlockState(), 3);
                    BlockEntity blockEntity = level.getBlockEntity(posA);
                    if (blockEntity instanceof PollinatedLeavesBlockEntity) {
                        PollinatedLeavesBlockEntity pollinatedLeavesBlockEntity = (PollinatedLeavesBlockEntity)blockEntity;
                        pollinatedLeavesBlockEntity.setLeafA(((BlockState)states.getFirst()).getBlock());
                        pollinatedLeavesBlockEntity.setLeafB(((BlockState)states.getSecond()).getBlock());
                        pollinatedLeavesBlockEntity.setResult(((TreePollinationRecipe)pickedRecipe.value()).result);
                        pollinatedLeavesBlockEntity.setChanged();
                    }
                }
            }
        }
    }
}

