/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.WoodSet;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TreeObject
extends WoodObject {
    private final ResourceKey<ConfiguredFeature<?, ?>> feature;
    private final ResourceKey<ConfiguredFeature<?, ?>> megaFeature;
    private final String style;
    private final Fruit fruit;
    private final MutationInfo mutationInfo;
    private final TagKey<Block> soil;
    private final TintStyle tintStyle;
    private final boolean fallingLeaves;
    private final GrowthCondition growthCondition;
    private final Decoration decoration;

    public TreeObject(ResourceLocation id, ResourceKey<ConfiguredFeature<?, ?>> feature, ResourceKey<ConfiguredFeature<?, ?>> megaFeature, String style, Optional<ResourceLocation> stripDrop, WoodObject.TreeColors colors, Fruit fruit, MutationInfo mutationInfo, TagKey<Block> soil, boolean fireProof, TintStyle tintStyle, boolean fallingLeaves, GrowthCondition growthCondition, Decoration decoration) {
        super(id, fireProof, colors, stripDrop);
        this.feature = feature;
        this.megaFeature = megaFeature;
        this.style = style;
        this.fruit = fruit;
        this.mutationInfo = mutationInfo;
        this.soil = soil;
        this.tintStyle = tintStyle;
        this.fallingLeaves = fallingLeaves;
        this.growthCondition = growthCondition;
        this.decoration = decoration;
    }

    public static Codec<TreeObject> codec(ResourceLocation id) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").orElse((Object)id).forGetter(WoodObject::getId), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).fieldOf("feature").orElse(TreeRegistrator.NULL_FEATURE).forGetter(TreeObject::getFeature), (App)ResourceLocation.CODEC.fieldOf("megaFeature").orElse(null).xmap(value -> value != null ? ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)value) : TreeRegistrator.NULL_FEATURE, value -> value != null ? value.location() : null).forGetter(TreeObject::getMegaFeature), (App)Codec.STRING.fieldOf("style").orElse((Object)id.getPath()).forGetter(TreeObject::getStyleName), (App)ResourceLocation.CODEC.optionalFieldOf("stripDrop").forGetter(WoodObject::getStripDrop), (App)WoodObject.TreeColors.CODEC.fieldOf("colors").orElse((Object)WoodObject.TreeColors.DEFAULT).forGetter(WoodObject::getColors), (App)Fruit.CODEC.fieldOf("fruit").orElse((Object)Fruit.DEFAULT).forGetter(TreeObject::getFruit), (App)MutationInfo.CODEC.fieldOf("mutation_info").orElse((Object)MutationInfo.DEFAULT).forGetter(TreeObject::getMutationInfo), (App)TagKey.hashedCodec((ResourceKey)Registries.BLOCK).fieldOf("soil").orElse(ModTags.DIRT_OR_FARMLAND).forGetter(TreeObject::getSoil), (App)Codec.BOOL.fieldOf("fireproof").orElse((Object)false).forGetter(WoodObject::isFireProof), (App)TintStyle.CODEC.fieldOf("tint").orElse((Object)TintStyle.HIVES).forGetter(TreeObject::getTintStyle), (App)Codec.BOOL.fieldOf("fallingLeaves").orElse((Object)false).forGetter(TreeObject::hasFallingLeaves), (App)GrowthCondition.CODEC.fieldOf("growthConditions").orElse((Object)GrowthCondition.DEFAULT).forGetter(TreeObject::getGrowthConditions), (App)Decoration.CODEC.fieldOf("decoration").orElse((Object)Decoration.DEFAULT).forGetter(TreeObject::getDecoration)).apply((Applicative)instance, TreeObject::new));
    }

    public ResourceKey<ConfiguredFeature<?, ?>> getFeature() {
        return this.feature;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> getMegaFeature() {
        return this.megaFeature;
    }

    @Override
    public WoodSet getStyle() {
        return WoodSet.STYLES.get(this.style);
    }

    private String getStyleName() {
        return this.style;
    }

    public Fruit getFruit() {
        return this.fruit;
    }

    public boolean hasFruit() {
        return !this.getFruit().fruitItem().equals((Object)ProductiveTrees.EMPTY_RL);
    }

    public MutationInfo getMutationInfo() {
        return this.mutationInfo;
    }

    public TagKey<Block> getSoil() {
        return this.soil;
    }

    public boolean canForceGrowth() {
        return this.growthCondition.canForceGrowth();
    }

    public TintStyle getTintStyle() {
        return this.tintStyle;
    }

    public boolean tintHives() {
        return this.tintStyle.equals((Object)TintStyle.FULL) || this.tintStyle.equals((Object)TintStyle.LEAVES_HIVES) || this.tintStyle.equals((Object)TintStyle.HIVES);
    }

    public boolean tintFruit() {
        return this.tintStyle.equals((Object)TintStyle.FULL) || this.tintStyle.equals((Object)TintStyle.FRUIT) || this.tintStyle.equals((Object)TintStyle.FRUIT_HIVES);
    }

    public boolean hasFallingLeaves() {
        return this.fallingLeaves;
    }

    public GrowthCondition getGrowthConditions() {
        return this.growthCondition;
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public record Fruit(String style, ResourceLocation fruitItem, int count, float growthSpeed, String flowerColor, String unripeColor, String ripeColor) {
        private static final Fruit DEFAULT = new Fruit("", ProductiveTrees.EMPTY_RL, 1, 1.0f, "", "", "");
        public static Codec<Fruit> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("style").orElse((Object)"default").forGetter(Fruit::style), (App)ResourceLocation.CODEC.fieldOf("item").forGetter(Fruit::fruitItem), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(Fruit::count), (App)Codec.FLOAT.fieldOf("growthSpeed").orElse((Object)Float.valueOf(1.0f)).forGetter(Fruit::growthSpeed), (App)Codec.STRING.fieldOf("flowerColor").orElse((Object)"#ffffff").forGetter(Fruit::flowerColor), (App)Codec.STRING.fieldOf("unripeColor").orElse((Object)"#1aa000").forGetter(Fruit::unripeColor), (App)Codec.STRING.fieldOf("ripeColor").orElse((Object)"#ff9d00").forGetter(Fruit::ripeColor)).apply((Applicative)instance, Fruit::new));

        public ItemStack getItem() {
            Item item = (Item)BuiltInRegistries.ITEM.get(this.fruitItem);
            return item != null ? new ItemStack((ItemLike)item, this.count) : ItemStack.EMPTY;
        }
    }

    public record MutationInfo(ResourceLocation target, float chance) {
        private static final MutationInfo DEFAULT = new MutationInfo(ProductiveTrees.EMPTY_RL, 0.0f);
        public static Codec<MutationInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("target").forGetter(MutationInfo::target), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(MutationInfo::chance)).apply((Applicative)instance, MutationInfo::new));
    }

    public static enum TintStyle implements StringRepresentable
    {
        NONE("none"),
        LEAVES("leaves"),
        LEAVES_HIVES("leaves_hives"),
        FRUIT("fruit"),
        FRUIT_HIVES("fruit_hives"),
        HIVES("hives"),
        FULL("full");

        public static final StringRepresentable.EnumCodec<TintStyle> CODEC;
        private final String name;

        private TintStyle(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(TintStyle::values);
        }
    }

    public record GrowthCondition(boolean canForceGrowth, int minLight, int maxLight, FluidStack fluid, Optional<HolderSet<Biome>> biome) {
        private static final GrowthCondition DEFAULT = new GrowthCondition(true, 9, 15, FluidStack.EMPTY, null);
        public static Codec<GrowthCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("canForceGrowth").orElse((Object)true).forGetter(GrowthCondition::canForceGrowth), (App)ExtraCodecs.POSITIVE_INT.fieldOf("minLight").orElse((Object)9).forGetter(GrowthCondition::minLight), (App)ExtraCodecs.POSITIVE_INT.fieldOf("maxLight").orElse((Object)15).forGetter(GrowthCondition::maxLight), (App)FluidStack.CODEC.fieldOf("fluid").orElse((Object)FluidStack.EMPTY).forGetter(GrowthCondition::fluid), (App)Biome.LIST_CODEC.optionalFieldOf("biome").forGetter(GrowthCondition::biome)).apply((Applicative)instance, GrowthCondition::new));
    }

    public record Decoration(String vine, Integer lightLevel) {
        private static final Decoration DEFAULT = new Decoration("", 0);
        public static Codec<Decoration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("vine").orElse((Object)"").forGetter(Decoration::vine), (App)Codec.INT.fieldOf("lightLevel").orElse((Object)0).forGetter(Decoration::lightLevel)).apply((Applicative)instance, Decoration::new));
    }
}

