/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class TreeFruitingRecipe
implements Recipe<RecipeInput> {
    public final Ingredient tree;
    public final ItemStack result;

    public TreeFruitingRecipe(Ingredient tree, ItemStack result) {
        this.tree = tree;
        this.result = result;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TreeRegistrator.TREE_FRUITING.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TreeRegistrator.TREE_FRUITING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<TreeFruitingRecipe> {
        private static final MapCodec<TreeFruitingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("tree").forGetter(recipe -> recipe.tree), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, TreeFruitingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TreeFruitingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TreeFruitingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TreeFruitingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static TreeFruitingRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            return new TreeFruitingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, TreeFruitingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.tree);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

