/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public class DynamicDataPack
extends PathPackResources {
    private final Path rootPath;
    private final PackType packType;
    private final PackLocationInfo packInfo;

    public DynamicDataPack(Path rootPath, PackType packType, PackLocationInfo packInfo) {
        super(packInfo, rootPath);
        ProductiveTrees.generateData();
        this.rootPath = rootPath;
        this.packType = packType;
        this.packInfo = packInfo;
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> metadataSectionSerializer) throws IOException {
        JsonObject jsonobject = new JsonObject();
        JsonObject packObject = new JsonObject();
        packObject.addProperty("pack_format", (Number)(this.packType.equals((Object)PackType.SERVER_DATA) ? 48 : 34));
        packObject.addProperty("description", "productivetrees");
        jsonobject.add("pack", (JsonElement)packObject);
        if (!jsonobject.has(metadataSectionSerializer.getMetadataSectionName())) {
            return null;
        }
        try {
            return (T)metadataSectionSerializer.fromJson(GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)metadataSectionSerializer.getMetadataSectionName()));
        }
        catch (JsonParseException jsonparseexception) {
            return null;
        }
    }
}

