/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class FruitLeafPlacerDecorator
extends TreeDecorator {
    public static final MapCodec<FruitLeafPlacerDecorator> CODEC = RecordCodecBuilder.mapCodec(decoratorInstance -> decoratorInstance.group((App)Codec.FLOAT.fieldOf("density").orElse((Object)Float.valueOf(0.5f)).forGetter(FruitLeafPlacerDecorator::getDensity), (App)Codec.INT.fieldOf("max_fruits").orElse((Object)100).forGetter(FruitLeafPlacerDecorator::getMaxFruits), (App)BlockStateProvider.CODEC.fieldOf("fruit_provider").forGetter(FruitLeafPlacerDecorator::getFruitProvider)).apply((Applicative)decoratorInstance, FruitLeafPlacerDecorator::new));
    private final float density;
    private final int maxFruits;
    public final BlockStateProvider fruitProvider;

    public FruitLeafPlacerDecorator(float density, int maxFruits, BlockStateProvider fruitProvider) {
        this.density = density;
        this.maxFruits = maxFruits;
        this.fruitProvider = fruitProvider;
    }

    public float getDensity() {
        return this.density;
    }

    public int getMaxFruits() {
        return this.maxFruits;
    }

    public BlockStateProvider getFruitProvider() {
        return this.fruitProvider;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)TreeRegistrator.FRUIT_LEAF_PLACER.get();
    }

    public void place(TreeDecorator.Context context) {
        if (context.leaves().isEmpty()) {
            return;
        }
        AtomicInteger count = new AtomicInteger();
        RandomSource rand = context.random();
        context.leaves().forEach(blockPos -> {
            if (count.get() < this.maxFruits && context.isAir(blockPos.below()) && rand.nextFloat() < this.density) {
                context.setBlock(blockPos.below(), this.fruitProvider.getState(rand, blockPos.below()));
                count.getAndIncrement();
            }
        });
    }
}

