/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivetrees.inventory.WoodWorkerContainer;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WoodWorkerBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    protected int tickCounter = 0;
    public static int SLOT_IN = 0;
    public static int SLOT_OUT = 1;
    public static int SLOT_AXE = 2;
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(3, (BlockEntity)this){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.isInputSlotItem(slot, stack);
        }

        public boolean isInputSlotItem(int slot, ItemStack stack) {
            return false;
        }

        public boolean isInsertableSlot(int slot) {
            return true;
        }

        public int[] getOutputSlots() {
            return new int[]{SLOT_OUT};
        }

        protected void onContentsChanged(int slot) {
            Level level;
            super.onContentsChanged(slot);
            if (slot == SLOT_AXE && (level = WoodWorkerBlockEntity.this.level) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendBlockUpdated(WoodWorkerBlockEntity.this.getBlockPos(), WoodWorkerBlockEntity.this.getBlockState(), WoodWorkerBlockEntity.this.getBlockState(), 2);
            }
        }
    };

    private boolean canProcess(ItemStack stack) {
        ItemStack stripped = TreeUtil.getStrippedItem(stack);
        return !stripped.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stripped);
    }

    public WoodWorkerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TreeRegistrator.WOOD_WORKER_BLOCK_ENTITY.get(), pos, state);
    }

    public Component getName() {
        return Component.translatable((String)((Block)TreeRegistrator.STRIPPER.get()).getDescriptionId());
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WoodWorkerBlockEntity blockEntity) {
        if (++blockEntity.tickCounter % 10 == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
        }
    }

    public ItemStack getAxe() {
        return this.inventoryHandler.getStackInSlot(SLOT_AXE);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new WoodWorkerContainer(windowId, playerInventory, this);
    }
}

