/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block;

import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ProductiveDrippyFruitBlock
extends ProductiveFruitBlock {
    private final Supplier<Block> puddle;

    public ProductiveDrippyFruitBlock(BlockBehaviour.Properties properties, TreeObject treeObject, Supplier<Block> puddle) {
        super(properties, treeObject);
        this.puddle = puddle;
    }

    @Override
    public boolean isRandomlyTicking(BlockState blockState) {
        return true;
    }

    @Override
    public void randomTick(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource random) {
        super.randomTick(state, level, blockPos, random);
        if (this.getAge(state) == ProductiveDrippyFruitBlock.getMaxAge()) {
            BlockState puddle = this.puddle.get().defaultBlockState();
            int n = 0;
            BlockPos.MutableBlockPos pointer = new BlockPos.MutableBlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
            while (n++ < 20 && level.getBlockState(pointer.below()).canBeReplaced() && !level.getBlockState(pointer.below()).is(puddle.getBlock())) {
                pointer.move(Direction.DOWN);
            }
            BlockState stateBelow = level.getBlockState(pointer.below());
            if (stateBelow.is(puddle.getBlock())) {
                int layers = Math.min(8, (Integer)stateBelow.getValue((Property)BlockStateProperties.LAYERS) + 1);
                if (layers > 3) {
                    for (Direction dir : Direction.values()) {
                        if (!dir.getAxis().isHorizontal() || !level.getBlockState(pointer.below().relative(dir)).canBeReplaced() || !level.getBlockState(pointer.below(2).relative(dir)).isFaceSturdy((BlockGetter)level, pointer.below(2).relative(dir), Direction.UP)) continue;
                        level.setBlockAndUpdate(pointer.below().relative(dir), puddle);
                    }
                    level.setBlockAndUpdate(pointer.below(), (BlockState)puddle.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(1)));
                } else {
                    level.setBlockAndUpdate(pointer.below(), (BlockState)puddle.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(layers)));
                }
            } else if (stateBelow.isFaceSturdy((BlockGetter)level, pointer.below(), Direction.UP)) {
                level.setBlockAndUpdate((BlockPos)pointer, puddle);
            }
            level.setBlock(blockPos, this.getStateForAge(state, 0), 2);
        }
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        return InteractionResult.SUCCESS;
    }
}

