/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.integration.jei;

import cy.jdkdigital.productivemetalworks.integration.jei.JeiPlugin;
import cy.jdkdigital.productivemetalworks.recipe.FluidAlloyingRecipe;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.util.FluidHelper;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class FluidAlloyingRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<FluidAlloyingRecipe>> {
    private final IDrawable background;

    public FluidAlloyingRecipeCategory(IGuiHelper guiHelper) {
        super(JeiPlugin.FLUID_ALLOYING, (Component)Component.translatable((String)"jei.productivemetalworks.fluid_alloying"), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MetalworksRegistrator.FOUNDRY_DRAINS.get(DyeColor.BLACK).get())), 165, 68);
        this.background = guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"productivemetalworks", (String)"textures/gui/jei/fluid_alloying.png"), 0, 0, 165, 68).setTextureSize(165, 68).build();
    }

    public void draw(RecipeHolder<FluidAlloyingRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<FluidAlloyingRecipe> recipe, IFocusGroup focuses) {
        int maxAmount = Math.max(((FluidAlloyingRecipe)recipe.value()).result.getAmount(), ((FluidAlloyingRecipe)recipe.value()).fluids.stream().map(SizedFluidIngredient::amount).max(Integer::compareTo).get());
        int fWidth = 42 / ((FluidAlloyingRecipe)recipe.value()).fluids.size();
        int leftover = 42 - fWidth * ((FluidAlloyingRecipe)recipe.value()).fluids.size();
        int fluidsSize = ((FluidAlloyingRecipe)recipe.value()).fluids.size();
        for (int i = 0; i < fluidsSize; ++i) {
            SizedFluidIngredient sizedFluidIngredient = ((FluidAlloyingRecipe)recipe.value()).fluids.get(i);
            List<FluidStack> fluidStacks = Arrays.stream(sizedFluidIngredient.getFluids()).filter(fluidStack -> fluidStack.getFluid().defaultFluidState().isSource()).toList();
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 12 + i * fWidth, 8).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStacks)).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.addAll(FluidHelper.formatTooltip((FluidStack)fluidStacks.getFirst()))).setFluidRenderer((long)maxAmount, false, fWidth + (leftover > 0 ? 1 : 0), 52).setSlotName("fluid" + i);
            --leftover;
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(Ingredient.of(fluidStacks.stream().map(f -> new ItemStack((ItemLike)f.getFluid().getBucket()))));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 112, 8).addFluidStack(((FluidAlloyingRecipe)recipe.value()).result.getFluid(), (long)((FluidAlloyingRecipe)recipe.value()).result.getAmount()).addRichTooltipCallback((recipeSlotView, tooltip) -> tooltip.addAll(FluidHelper.formatTooltip(((FluidAlloyingRecipe)recipe.value()).result))).setFluidRenderer((long)maxAmount, false, 42, 52).setSlotName("result");
    }
}

