/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block.entity;

import cy.jdkdigital.productivelib.common.block.entity.AbstractBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FoundryTapBlockEntity
extends AbstractBlockEntity {
    public boolean isActive = false;
    public int fluidId = 0;

    public FoundryTapBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)MetalworksRegistrator.FOUNDRY_TAP_BLOCK_ENTITY.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, FoundryTapBlockEntity blockEntity) {
        if (blockEntity.isActive) {
            Direction direction = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            IFluidHandler source = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockPos.relative(direction.getOpposite()), (Object)direction);
            IFluidHandler destination = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockPos.below(), (Object)Direction.UP);
            if (source != null && destination != null && !FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)source, (int)10, (boolean)false).isEmpty()) {
                FluidUtil.tryFluidTransfer((IFluidHandler)destination, (IFluidHandler)source, (int)10, (boolean)true);
                int fId = BuiltInRegistries.FLUID.getId((Object)destination.getFluidInTank(0).getFluid());
                if (blockEntity.fluidId != fId) {
                    blockEntity.fluidId = fId;
                    blockEntity.sync(level);
                }
            } else {
                blockEntity.isActive = false;
                blockEntity.fluidId = 0;
                blockEntity.sync(level);
            }
        }
    }

    public void toggleActive() {
        Direction dir = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (this.level != null && this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos().relative(dir.getOpposite()), (Object)dir) != null) {
            boolean bl = this.isActive = !this.isActive;
            if (!this.isActive) {
                this.fluidId = 0;
            }
            if (this.level != null) {
                this.sync(this.level);
            }
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("fluidId")) {
            this.fluidId = tag.getInt("fluidId");
        }
        this.isActive = tag.contains("isActive") && tag.getBoolean("isActive");
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        tag.putInt("fluidId", this.fluidId);
        tag.putBoolean("isActive", this.isActive);
    }

    public void sync(Level level) {
        level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }
}

