/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block;

import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MeatBlock
extends RotatedPillarBlock {
    public static final IntegerProperty BITES = IntegerProperty.create((String)"meat_bites", (int)0, (int)7);
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public MeatBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue((Property)AXIS, (Comparable)Direction.Axis.Y));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BITES});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return MeatBlock.eat(level, pos, state, player);
    }

    protected void attack(BlockState state, Level level, BlockPos pos, Player player) {
        if (!level.isClientSide) {
            level.playSound(player, pos, SoundEvents.SLIME_SQUISH, SoundSource.BLOCKS);
        }
        super.attack(state, level, pos, player);
    }

    protected static InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(false) || player.getUseItem().is(((Block)MetalworksRegistrator.MEAT_BLOCK.get()).asItem())) {
            return InteractionResult.PASS;
        }
        player.getFoodData().eat(2, 0.1f);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (level instanceof ServerLevel) {
            int i = (Integer)state.getValue((Property)BITES);
            if (i < 7) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
            } else {
                level.removeBlock(pos, false);
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Items.BONE.getDefaultInstance());
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

