/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivelib.common.block.IMultiBlockPeripheral;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryTapBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FoundryTapBlock
extends BaseEntityBlock
implements IMultiBlockPeripheral {
    public static final MapCodec<FoundryTapBlock> CODEC = FoundryTapBlock.simpleCodec(FoundryTapBlock::new);
    Map<Direction, VoxelShape> SHAPES = new HashMap(){
        {
            this.put(Direction.WEST, Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.375, (double)0.375, (double)0.375, (double)1.0, (double)0.625, (double)0.625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.375, (double)0.3125, (double)0.375, (double)0.625, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.OR));
            this.put(Direction.NORTH, Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)1.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.375, (double)0.3125, (double)0.375, (double)0.625, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.OR));
            this.put(Direction.EAST, Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.0, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.375, (double)0.3125, (double)0.375, (double)0.625, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.OR));
            this.put(Direction.SOUTH, Shapes.join((VoxelShape)Shapes.join((VoxelShape)Shapes.empty(), (VoxelShape)Shapes.box((double)0.375, (double)0.375, (double)0.0, (double)0.625, (double)0.625, (double)0.625), (BooleanOp)BooleanOp.OR), (VoxelShape)Shapes.box((double)0.375, (double)0.3125, (double)0.375, (double)0.625, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.OR));
        }
    };

    public FoundryTapBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPES.get(state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FoundryTapBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : FoundryTapBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)MetalworksRegistrator.FOUNDRY_TAP_BLOCK_ENTITY.get()), FoundryTapBlockEntity::serverTick);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FoundryTapBlockEntity) {
            FoundryTapBlockEntity blockEntity2 = (FoundryTapBlockEntity)blockEntity;
            if (!level.isClientSide) {
                blockEntity2.toggleActive();
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FoundryTapBlockEntity) {
            boolean hasSignal;
            FoundryTapBlockEntity blockEntity2 = (FoundryTapBlockEntity)blockEntity;
            boolean bl = hasSignal = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
            if (hasSignal) {
                blockEntity2.toggleActive();
            }
        }
    }
}

