/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.productivelib.common.block.IMultiBlockPeripheral;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryControllerBlockEntity;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryDrainBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FoundryDrainBlock
extends BaseEntityBlock
implements IMultiBlockPeripheral {
    public static final MapCodec<FoundryDrainBlock> CODEC = FoundryDrainBlock.simpleCodec(FoundryDrainBlock::new);

    public FoundryDrainBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)pContext.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FoundryDrainBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        FoundryDrainBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof FoundryDrainBlockEntity && (blockEntity = (FoundryDrainBlockEntity)blockEntity2).getMultiblockController() != null && stack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
            ServerLevel serverLevel;
            BlockEntity blockEntity3;
            if (level instanceof ServerLevel && (blockEntity3 = (serverLevel = (ServerLevel)level).getBlockEntity(blockEntity.getMultiblockController())) instanceof FoundryControllerBlockEntity) {
                FoundryControllerBlockEntity foundryController = (FoundryControllerBlockEntity)blockEntity3;
                FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)foundryController.fluidHandler);
                foundryController.sync((Level)serverLevel);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

