/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivemetalworks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cy.jdkdigital.productivemetalworks.common.block.entity.FoundryTapBlockEntity;
import cy.jdkdigital.productivemetalworks.registry.MetalworksRegistrator;
import cy.jdkdigital.productivemetalworks.util.RenderHelper;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FoundryTapBlockEntityRenderer
implements BlockEntityRenderer<FoundryTapBlockEntity> {
    public FoundryTapBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FoundryTapBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        FluidStack fluidStack;
        if (blockEntity.getLevel() != null && blockEntity.isActive && !(fluidStack = new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(blockEntity.fluidId), 1)).isEmpty()) {
            poseStack.pushPose();
            VertexConsumer vertexBuffer = bufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            float fluidY = RenderHelper.halfPixelFraction + 5.0f * RenderHelper.pixelFraction;
            RenderHelper.renderCenteredFluidColumn(poseStack, vertexBuffer, 3.0f, 0.0f, fluidY, fluidStack, combinedLightIn, combinedOverlayIn, 1.0f);
            if (blockEntity.getLevel().getBlockState(blockEntity.getBlockPos().below()).is(MetalworksRegistrator.CASTING_BASIN)) {
                RenderHelper.renderCenteredFluidColumn(poseStack, vertexBuffer, 3.0f, -0.99f, 0.0f, fluidStack, combinedLightIn, combinedOverlayIn, 1.0f);
            }
            poseStack.popPose();
        }
    }
}

