/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.state.properties;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public enum VerticalHive implements StringRepresentable
{
    NONE("none"),
    UP("up"),
    DOWN("down"),
    LEFT("left"),
    RIGHT("right"),
    BACK("back");

    private final String name;

    private VerticalHive(String name) {
        this.name = name;
    }

    @Nonnull
    public String getSerializedName() {
        return this.name;
    }

    public String toString() {
        return this.getSerializedName();
    }

    public VerticalHive opposite() {
        if (this.equals((Object)UP)) {
            return DOWN;
        }
        if (this.equals((Object)DOWN)) {
            return UP;
        }
        if (this.equals((Object)LEFT)) {
            return RIGHT;
        }
        if (this.equals((Object)RIGHT)) {
            return LEFT;
        }
        return NONE;
    }

    public Direction getExpandedCardinalDirection(Direction facing) {
        return switch (this.ordinal()) {
            case 1 -> Direction.UP;
            case 2 -> Direction.DOWN;
            case 3 -> facing.getClockWise();
            case 4 -> facing.getCounterClockWise();
            case 5 -> facing.getOpposite();
            default -> facing;
        };
    }
}

