/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;

public class SolitaryNestFeature
extends Feature<ReplaceBlockConfiguration> {
    protected final String configKey;
    protected boolean placeOntop;

    public SolitaryNestFeature(String configKey, Codec<ReplaceBlockConfiguration> configFactory) {
        this(configKey, configFactory, false);
    }

    public SolitaryNestFeature(String configKey, Codec<ReplaceBlockConfiguration> configFactory, boolean placeOntop) {
        super(configFactory);
        this.configKey = configKey;
        this.placeOntop = placeOntop;
    }

    public boolean place(FeaturePlaceContext<ReplaceBlockConfiguration> context) {
        WorldGenLevel level = context.level();
        RandomSource rand = context.random();
        BlockPos blockPos = context.origin();
        ReplaceBlockConfiguration featureConfig = (ReplaceBlockConfiguration)context.config();
        for (OreConfiguration.TargetBlockState targetBlockState : featureConfig.targetStates) {
            BlockState state;
            if (ProductiveBeesConfig.WORLD_GEN.nestConfigs.containsKey(this.configKey) && rand.nextFloat() > ((Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get(this.configKey).get()).floatValue()) {
                return false;
            }
            blockPos = blockPos.south(rand.nextInt(14)).east(rand.nextInt(14));
            while (blockPos.getY() < 50 || !level.isEmptyBlock(blockPos)) {
                blockPos = blockPos.above();
            }
            if (!this.placeOntop) {
                blockPos = blockPos.below();
            }
            if (!targetBlockState.target.test(state = this.placeOntop ? level.getBlockState(blockPos.below()) : level.getBlockState(blockPos), rand)) continue;
            return this.placeNest(level, blockPos, targetBlockState.state, rand);
        }
        return false;
    }

    protected boolean placeNest(WorldGenLevel level, BlockPos pos, BlockState state, RandomSource random) {
        Direction direction = state.getBlock() instanceof WoodNest ? Direction.SOUTH : Direction.UP;
        for (Direction dir : BlockStateProperties.FACING.getPossibleValues()) {
            BlockPos blockPos = pos.relative(dir, 1);
            if (!level.isEmptyBlock(blockPos)) continue;
            direction = dir;
            break;
        }
        BlockState newState = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)direction);
        boolean result = level.setBlock(pos, newState, 1);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SolitaryNestBlockEntity) {
            SolitaryNestBlockEntity nestBlockEntity = (SolitaryNestBlockEntity)blockEntity;
            Block block = state.getBlock();
            if (block instanceof SolitaryNest) {
                SolitaryNest nestBlock = (SolitaryNest)block;
                ProductiveBees.LOGGER.debug("Spawned nest at " + String.valueOf(pos) + " " + String.valueOf(newState));
                try {
                    List<RecipeHolder<BeeSpawningRecipe>> recipes = SolitaryNest.getSpawningRecipes(nestBlock, (Level)level.getLevel(), (Holder<Biome>)level.getBiome(pos), ItemStack.EMPTY);
                    if (recipes.size() > 0) {
                        RecipeHolder<BeeSpawningRecipe> spawningRecipe;
                        RecipeHolder<BeeSpawningRecipe> recipeHolder = spawningRecipe = recipes.size() == 1 ? recipes.get(0) : recipes.get(random.nextInt(recipes.size()));
                        if (((BeeSpawningRecipe)spawningRecipe.value()).output.size() > 0) {
                            BeeIngredient beeIngredient = ((BeeSpawningRecipe)spawningRecipe.value()).output.get(random.nextInt(((BeeSpawningRecipe)spawningRecipe.value()).output.size())).get();
                            CompoundTag bee = BeeHelper.getBeeAsCompoundTag(beeIngredient);
                            nestBlockEntity.addOccupantFromTag(bee, random.nextInt(599), 600);
                        }
                    }
                }
                catch (Exception e) {
                    ProductiveBees.LOGGER.warn("Failed to put bees into solitary nest :(" + e.getMessage());
                }
            }
        }
        return result;
    }
}

