/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.common.entity.bee.solitary.BlueBandedBee;
import cy.jdkdigital.productivebees.dispenser.CageDispenseBehavior;
import cy.jdkdigital.productivebees.dispenser.ShearsDispenseItemBehavior;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.network.packets.BeeDataMessage;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="productivebees", bus=EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.BEE_CAGE.get()), (DispenseItemBehavior)new CageDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.STURDY_BEE_CAGE.get()), (DispenseItemBehavior)new CageDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)Items.SHEARS.asItem(), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
        });
    }

    @SubscribeEvent
    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        EntityType bee;
        for (DeferredHolder registryObject : ModEntities.HIVE_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            event.put(bee, Bee.createAttributes().build());
        }
        for (DeferredHolder registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            if (bee.getDescriptionId().contains("blue_banded_bee")) continue;
            event.put(bee, Bee.createAttributes().build());
        }
        event.put((EntityType)ModEntities.BLUE_BANDED_BEE.get(), BlueBandedBee.getDefaultAttributes().build());
    }

    @SubscribeEvent
    public static void payloadHandler(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("productivebees").versioned("1").optional();
        registrar.playToClient(BeeDataMessage.TYPE, BeeDataMessage.STREAM_CODEC, (IPayloadHandler)new DirectionalPayloadHandler(BeeDataMessage::clientHandle, BeeDataMessage::serverHandle));
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
    }

    @SubscribeEvent
    public static void registerBlockEntityCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.ADVANCED_HIVE.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.CANVAS_ADVANCED_HIVE.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.EXPANSION_BOX.get(), (myBlockEntity, side) -> {
            if (side != null && (side.equals((Object)Direction.DOWN) || side.equals((Object)Direction.UP))) {
                return myBlockEntity.getHiveUpgradeHandler();
            }
            return myBlockEntity.getHiveInventoryHandler();
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, ModBlockEntityTypes.CANVAS_EXPANSION_BOX.get(), (myBlockEntity, side) -> {
            if (side != null && (side.equals((Object)Direction.DOWN) || side.equals((Object)Direction.UP))) {
                return myBlockEntity.getHiveUpgradeHandler();
            }
            return myBlockEntity.getHiveInventoryHandler();
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.DRACONIC_BEEHIVE.get(), (myBlockEntity, side) -> myBlockEntity.inventoryHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.POWERED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.POWERED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.POWERED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.HEATED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.HEATED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.HEATED_CENTRIFUGE.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BOTTLER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BOTTLER.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.FEEDER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.JAR.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.HONEY_GENERATOR.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.HONEY_GENERATOR.get(), (myBlockEntity, side) -> myBlockEntity.getFluidHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.HONEY_GENERATOR.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.CATCHER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.INCUBATOR.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.INCUBATOR.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.GENE_INDEXER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.BREEDING_CHAMBER.get(), (myBlockEntity, side) -> myBlockEntity.getItemHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)ModBlockEntityTypes.BREEDING_CHAMBER.get(), (myBlockEntity, side) -> myBlockEntity.getEnergyHandler());
    }
}

