/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.client.render.item.JarBlockItemRenderer;
import cy.jdkdigital.productivebees.common.advancements.criterion.FishBeeTrigger;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.compat.minecolonies.MinecolonyCompat;
import cy.jdkdigital.productivebees.gen.feature.WoodNestDecorator;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModConfiguredFeatures;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModProfessions;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.network.packets.BeeDataMessage;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.event.AddEntityToFilterEvent;
import cy.jdkdigital.productivelib.event.UpgradeTooltipEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="productivebees")
public class EventHandler {
    @SubscribeEvent
    public static void onServerStarting(AddReloadListenerEvent event) {
        BeeReloadListener.INSTANCE.context = event.getConditionContext();
        event.addListener((PreparableReloadListener)BeeReloadListener.INSTANCE);
    }

    @SubscribeEvent
    public static void addEntityToFilter(AddEntityToFilterEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ConfigurableBee) {
            ConfigurableBee bee = (ConfigurableBee)livingEntity;
            ResourceLocation type = ResourceLocation.parse((String)BeeIngredientFactory.getIngredientKey(bee));
            event.setKey(type);
        }
    }

    @SubscribeEvent
    public static void addUpgradeTooltip(UpgradeTooltipEvent event) {
        if (event.getEntities() != null) {
            ArrayList leftovers = new ArrayList();
            event.getEntities().forEach(resourceLocation -> {
                Supplier<BeeIngredient> type = BeeIngredientFactory.getIngredient(resourceLocation.toString());
                if (type.get() != null && type.get().isConfigurable()) {
                    event.getTooltipComponents().add(Component.translatable((String)"productivelib.information.upgrade.upgrade_entity_filter.list_item", (Object[])new Object[]{Component.translatable((String)("entity.productivebees." + type.get().getBeeType().getPath() + "_bee")).getString()}).withStyle(ChatFormatting.GOLD));
                } else {
                    leftovers.add(resourceLocation);
                }
            });
            event.setEntities(leftovers);
        } else {
            double value;
            ResourceLocation upgradeType = BuiltInRegistries.ITEM.getKey((Object)event.getStack().getItem());
            switch (upgradeType.getPath()) {
                case "upgrade_child": {
                    double d = (Double)ProductiveBeesConfig.UPGRADES.breedingChance.get();
                    break;
                }
                case "upgrade_time": {
                    double d = (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
                    break;
                }
                case "upgrade_time_2": {
                    double d = (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * 2.0;
                    break;
                }
                case "upgrade_productivity": {
                    double d = (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier.get();
                    break;
                }
                case "upgrade_productivity_2": {
                    double d = (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier2.get();
                    break;
                }
                case "upgrade_productivity_3": {
                    double d = (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier3.get();
                    break;
                }
                case "upgrade_productivity_4": {
                    double d = (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier4.get();
                    break;
                }
                default: {
                    double d = value = 0.0;
                }
            }
            if (upgradeType.getNamespace().equals("productivelib")) {
                event.getTooltipComponents().add(Component.translatable((String)("productivebees.information.upgrade." + upgradeType.getPath()), (Object[])new Object[]{(int)(value * 100.0)}).withStyle(ChatFormatting.GOLD));
            }
            switch (upgradeType.getPath()) {
                case "upgrade_entity_filter": {
                    event.addValidBlock((Component)Component.literal((String)"Advanced Beehive"));
                    event.addValidBlock((Component)Component.literal((String)"Catcher"));
                    event.addValidBlock((Component)Component.literal((String)"Centrifuge"));
                    break;
                }
                case "upgrade_adult": 
                case "upgrade_child": 
                case "upgrade_range": {
                    event.addValidBlock((Component)Component.literal((String)"Advanced Beehive"));
                    event.addValidBlock((Component)Component.literal((String)"Catcher"));
                    break;
                }
                case "upgrade_gene_sampler": 
                case "upgrade_anti_teleport": 
                case "upgrade_block": 
                case "upgrade_simulator": 
                case "upgrade_productivity_2": 
                case "upgrade_productivity_3": 
                case "upgrade_productivity_4": {
                    event.addValidBlock((Component)Component.literal((String)"Advanced Beehive"));
                    break;
                }
                case "upgrade_time": {
                    event.addValidBlock((Component)Component.literal((String)"Advanced Beehive"));
                    event.addValidBlock((Component)Component.literal((String)"Centrifuge"));
                    event.addValidBlock((Component)Component.literal((String)"Breeding Chamber"));
                    event.addValidBlock((Component)Component.literal((String)"Incubator"));
                    event.addValidBlock((Component)Component.literal((String)"Honey Generator"));
                    break;
                }
                case "upgrade_time_2": {
                    event.addValidBlock((Component)Component.literal((String)"Centrifuge"));
                    event.addValidBlock((Component)Component.literal((String)"Breeding Chamber"));
                    event.addValidBlock((Component)Component.literal((String)"Incubator"));
                    event.addValidBlock((Component)Component.literal((String)"Honey Generator"));
                    break;
                }
                case "upgrade_productivity": {
                    event.addValidBlock((Component)Component.literal((String)"Advanced Beehive"));
                    event.addValidBlock((Component)Component.literal((String)"Honey Generator"));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDataSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BeeDataMessage(BeeReloadListener.INSTANCE.getData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)event.getPlayer(), (CustomPacketPayload)new BeeDataMessage(BeeReloadListener.INSTANCE.getData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            if (!bee.level().isClientSide && bee.isLeashed() && bee.tickCount % (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.leashedTicks.get() == 0) {
                boolean isInDayCycleDanger;
                GeneValue behavior;
                BeeAttributesHandler attributes = (BeeAttributesHandler)bee.getData(ProductiveBees.ATTRIBUTE_HANDLER);
                GeneValue tolerance = attributes.getAttributeValue(GeneAttribute.WEATHER_TOLERANCE);
                if (tolerance.getValue() < 2 && (double)bee.level().random.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.toleranceChance.get()) {
                    if (tolerance.equals((Object)GeneValue.WEATHER_TOLERANCE_NONE) && (bee.level().isRaining() || bee.level().isThundering())) {
                        attributes.setAttributeValue(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_RAIN);
                    } else if (tolerance.equals((Object)GeneValue.WEATHER_TOLERANCE_RAIN) && bee.level().isThundering()) {
                        attributes.setAttributeValue(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_ANY);
                    }
                }
                if ((behavior = attributes.getAttributeValue(GeneAttribute.BEHAVIOR)).getValue() < 2 && (double)bee.level().random.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.behaviorChance.get()) {
                    if (behavior.equals((Object)GeneValue.BEHAVIOR_DIURNAL) && bee.level().isNight()) {
                        attributes.setAttributeValue(GeneAttribute.BEHAVIOR, bee.level().random.nextFloat() < 0.85f ? GeneValue.BEHAVIOR_NOCTURNAL : GeneValue.BEHAVIOR_METATURNAL);
                    } else if (behavior.equals((Object)GeneValue.BEHAVIOR_NOCTURNAL) && !bee.level().isNight()) {
                        attributes.setAttributeValue(GeneAttribute.BEHAVIOR, bee.level().random.nextFloat() < 0.9f ? GeneValue.BEHAVIOR_METATURNAL : GeneValue.BEHAVIOR_DIURNAL);
                    }
                }
                boolean isInDangerFromRain = tolerance.equals((Object)GeneValue.WEATHER_TOLERANCE_NONE) && bee.level().isRaining();
                boolean bl = isInDayCycleDanger = behavior.equals((Object)GeneValue.BEHAVIOR_DIURNAL) && bee.level().isNight() || behavior.equals((Object)GeneValue.BEHAVIOR_NOCTURNAL) && bee.level().isDay();
                if ((isInDangerFromRain || isInDayCycleDanger) && (double)bee.level().random.nextFloat() < (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.damageChance.get()) {
                    bee.hurt(isInDangerFromRain ? bee.level().damageSources().drown() : bee.level().damageSources().generic(), bee.getMaxHealth() / 3.0f - 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingIncomingDamageEvent event) {
        ConfigurableBee bee;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ConfigurableBee && (bee = (ConfigurableBee)livingEntity).isIrradiated() && event.getSource().getMsgId().equals("mekanism.radiation")) {
            if (bee.breathCollectionCooldown < 0) {
                bee.breathCollectionCooldown = 600;
                bee.internalSetHasNectar(true);
            } else {
                bee.breathCollectionCooldown = (int)((float)bee.breathCollectionCooldown - event.getAmount());
            }
            event.setCanceled(true);
            bee.level().broadcastEntityEvent((Entity)bee, (byte)2);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ConfigurableBee) {
            ConfigurableBee bee = (ConfigurableBee)livingEntity;
            if (event.getSource().getMsgId().equals("mekanism.radiation") && bee.getBeeType().equals((Object)ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"radioactive")) && (Double)ProductiveBeesConfig.BEES.deadBeeConvertChance.get() > event.getEntity().level().random.nextDouble() && BeeIngredientFactory.getIngredient("productivebees:wasted_radioactive").get() != null) {
                event.setCanceled(true);
                bee.setHealth(bee.getMaxHealth());
                bee.setBeeType("productivebees:wasted_radioactive");
            }
        } else {
            Entity newBee;
            livingEntity = event.getEntity();
            if (livingEntity instanceof Bee) {
                Bee bee = (Bee)livingEntity;
                if (bee.level().getBlockState(bee.blockPosition()).is(Blocks.WHITE_CONCRETE_POWDER) && (newBee = ((EntityType)ModEntities.CONFIGURABLE_BEE.get()).create(bee.level())) instanceof ConfigurableBee) {
                    ConfigurableBee configurableBee = (ConfigurableBee)newBee;
                    configurableBee.setBeeType("productivebees:phil");
                    configurableBee.moveTo(bee.blockPosition().relative(Direction.UP), bee.getYRot(), bee.getXRot());
                    bee.level().addFreshEntity(newBee);
                }
            } else if (((Boolean)ProductiveBeesConfig.GENERAL.enableJokes.get()).booleanValue() && event.getEntity() instanceof Villager && Calendar.getInstance().get(2) + 1 == 4 && Calendar.getInstance().get(5) == 1 && (newBee = ((EntityType)ModEntities.CONFIGURABLE_BEE.get()).create(event.getEntity().level())) instanceof ConfigurableBee) {
                ConfigurableBee configurableBee = (ConfigurableBee)newBee;
                configurableBee.setBeeType("productivebees:villager");
                configurableBee.setPos(event.getEntity().position().relative(Direction.UP, 1.0));
                configurableBee.internalSetHasNectar(true);
                event.getEntity().level().addFreshEntity((Entity)configurableBee);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent.Post event) {
        Entity damageSource = event.getSource().getEntity();
        if (damageSource instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)damageSource;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                boolean isWearingBeeHelmet = false;
                ItemStack itemstack = player.getItemBySlot(EquipmentSlot.HEAD);
                if (!itemstack.isEmpty() && itemstack.getItem().equals(ModItems.BEE_NEST_DIAMOND_HELMET.get())) {
                    isWearingBeeHelmet = true;
                }
                if (isWearingBeeHelmet && player.level().random.nextDouble() < (Double)ProductiveBeesConfig.BEES.kamikazBeeChance.get()) {
                    Level level = player.level();
                    ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).create(level);
                    BlockPos pos = player.blockPosition();
                    if (bee != null) {
                        bee.setBeeType("productivebees:kamikaz");
                        bee.setDefaultAttributes();
                        bee.setTarget(attacker);
                        bee.moveTo(pos.getX(), (double)pos.getY() + 0.5, pos.getZ(), bee.getYRot(), bee.getXRot());
                        level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 0.2, 0.1, 0.2);
                        level.playSound(player, pos, SoundEvents.BEE_HURT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        level.addFreshEntity((Entity)bee);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockGrow(BlockGrowFeatureEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            if ((Double)ProductiveBeesConfig.WORLD_GEN.treeGrowNestChance.get() > 0.0) {
                Block feature;
                if (ModList.get().isLoaded("minecolonies") && !MinecolonyCompat.canGrowAt((Level)serverLevel, event.getPos())) {
                    return;
                }
                WoodNestDecorator decorator = null;
                float r = serverLevel.getRandom().nextFloat();
                boolean canSpawnNest = EventHandler.hasFlowers((LevelAccessor)serverLevel, event.getPos()) && (double)r < (Double)ProductiveBeesConfig.WORLD_GEN.treeGrowNestChance.get();
                Block grownBlock = serverLevel.getBlockState(event.getPos()).getBlock();
                if (canSpawnNest && grownBlock.equals(Blocks.OAK_SAPLING)) {
                    decorator = new WoodNestDecorator(((Block)ModBlocks.OAK_WOOD_NEST.get()).defaultBlockState());
                } else if (canSpawnNest && grownBlock.equals(Blocks.BIRCH_SAPLING)) {
                    decorator = new WoodNestDecorator(((Block)ModBlocks.BIRCH_WOOD_NEST.get()).defaultBlockState());
                } else if (canSpawnNest && grownBlock.equals(Blocks.SPRUCE_SAPLING)) {
                    decorator = new WoodNestDecorator(((Block)ModBlocks.SPRUCE_WOOD_NEST.get()).defaultBlockState());
                } else if (canSpawnNest && grownBlock.equals(Blocks.ACACIA_SAPLING)) {
                    decorator = new WoodNestDecorator(((Block)ModBlocks.ACACIA_WOOD_NEST.get()).defaultBlockState());
                } else if (canSpawnNest && grownBlock.equals(Blocks.DARK_OAK_SAPLING)) {
                    decorator = new WoodNestDecorator(((Block)ModBlocks.DARK_OAK_WOOD_NEST.get()).defaultBlockState());
                } else if (canSpawnNest && grownBlock.equals(Blocks.JUNGLE_SAPLING)) {
                    decorator = new WoodNestDecorator(((Block)ModBlocks.JUNGLE_WOOD_NEST.get()).defaultBlockState());
                } else if (canSpawnNest && grownBlock.equals(Blocks.CHERRY_SAPLING)) {
                    decorator = new WoodNestDecorator(((Block)ModBlocks.CHERRY_WOOD_NEST.get()).defaultBlockState());
                } else if (canSpawnNest && grownBlock.equals(Blocks.MANGROVE_PROPAGULE)) {
                    decorator = new WoodNestDecorator(((Block)ModBlocks.MANGROVE_WOOD_NEST.get()).defaultBlockState());
                } else if ((double)r < (Double)ProductiveBeesConfig.WORLD_GEN.treeGrowNestChance.get() && (grownBlock.equals(Blocks.CRIMSON_FUNGUS) || grownBlock.equals(Blocks.WARPED_FUNGUS))) {
                    ResourceKey<ConfiguredFeature<?, ?>> featureKey = grownBlock.equals(Blocks.CRIMSON_FUNGUS) ? ModConfiguredFeatures.CRIMSON_FUNGUS_BEES_GROWN : ModConfiguredFeatures.WARPED_FUNGUS_BEES_GROWN;
                    feature = event.getLevel().registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder(featureKey).orElse(null);
                    event.setFeature((Holder)feature);
                }
                if (decorator != null) {
                    feature = decorator.getNest().getBlock();
                    if (feature instanceof WoodNest) {
                        WoodNest woodNest = (WoodNest)feature;
                        decorator.setBeeRecipes(SolitaryNest.getSpawningRecipes(woodNest, (Level)serverLevel, (Holder<Biome>)serverLevel.getBiome(event.getPos()), ItemStack.EMPTY));
                    }
                    Holder feature2 = event.getFeature();
                    WoodNestDecorator finalDecorator = decorator;
                    ((ConfiguredFeature)feature2.value()).getFeatures().forEach(configuredFeature -> {
                        FeatureConfiguration patt0$temp = configuredFeature.config();
                        if (patt0$temp instanceof TreeConfiguration) {
                            TreeConfiguration treeConfig = (TreeConfiguration)patt0$temp;
                            ArrayList<TreeDecorator> decorators = new ArrayList<TreeDecorator>(treeConfig.decorators);
                            decorators.add(finalDecorator);
                            treeConfig.decorators = decorators;
                        }
                    });
                    event.setFeature(feature2);
                }
            }
        }
    }

    private static boolean hasFlowers(LevelAccessor pLevel, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.MutableBlockPos.betweenClosed((BlockPos)pPos.below().north(2).west(2), (BlockPos)pPos.above().south(2).east(2))) {
            BlockState state = pLevel.getBlockState(blockpos);
            if (!state.is(BlockTags.FLOWERS) || state.is(ModTags.NOT_FLOWERS)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        event.getGenericTrades().add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 10), Optional.empty(), new ItemStack((ItemLike)ModItems.STURDY_BEE_CAGE.get()), 1, 12, 6, 0.2f));
        event.getGenericTrades().add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 24), Optional.empty(), new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"spawn_egg_bumble_bee"))), 3, 12, 6, 0.2f));
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType().equals(ModProfessions.BEEKEEPER.get())) {
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.CAMPFIRE), Optional.empty(), new ItemStack((ItemLike)Items.EMERALD), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD), Optional.empty(), new ItemStack((ItemLike)Items.GLASS_BOTTLE, 4), 1, 32, 3, 0.2f));
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), Optional.empty(), new ItemStack((ItemLike)Items.SHEARS), 3, 12, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.HONEY_BOTTLE, 2), Optional.empty(), new ItemStack((ItemLike)Items.EMERALD), 3, 10, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD), Optional.empty(), new ItemStack((ItemLike)ModItems.BEE_CAGE.get(), 4), 3, 64, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), Optional.empty(), new ItemStack((ItemLike)ModItems.SUGARBAG_HONEYCOMB.get()), 3, 32, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD), Optional.empty(), new ItemStack((ItemLike)ModItems.TREAT_ON_A_STICK.get()), 3, 8, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> {
                if (rand.nextBoolean()) {
                    return new MerchantOffer(new ItemCost((ItemLike)ModItems.HONEY_TREAT.get(), 4), Optional.empty(), new ItemStack((ItemLike)Items.EMERALD), 3, 50, 3, 0.2f);
                }
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD), Optional.empty(), new ItemStack((ItemLike)ModItems.HONEY_TREAT.get(), 2), 3, 100, 3, 0.2f);
            });
            ArrayList<Block> hiveMap = new ArrayList<Block>(){
                {
                    this.add((Block)ModBlocks.HIVES.get("advanced_jungle_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_acacia_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_birch_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_dark_oak_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_mangrove_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_spruce_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_cherry_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_oak_beehive").get());
                }
            };
            ArrayList<Block> boxMap = new ArrayList<Block>(){
                {
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_jungle").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_acacia").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_birch").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_dark_oak").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_mangrove").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_spruce").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_cherry").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_oak").get());
                }
            };
            int picked = new Random().nextInt(hiveMap.size());
            ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BEEHIVE, 1), Optional.of(new ItemCost((ItemLike)Items.EMERALD, 6)), new ItemStack((ItemLike)hiveMap.get(picked)), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), Optional.empty(), new ItemStack((ItemLike)boxMap.get(picked)), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), Optional.of(new ItemCost((ItemLike)ModItems.BEE_CAGE.get(), 1)), new ItemStack((ItemLike)ModItems.STURDY_BEE_CAGE.get()), 3, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), Optional.empty(), new ItemStack((ItemLike)ModBlocks.JAR.get(), 1), 2, 12, 8, 0.2f));
            ((List)event.getTrades().get(5)).add((trader, rand) -> {
                ItemStack nest = new ItemStack((ItemLike)Items.BEE_NEST);
                nest.applyComponents(DataComponentMap.builder().set(DataComponents.BEES, List.of(BeehiveBlockEntity.Occupant.create((int)0))).build());
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 32), Optional.empty(), nest, 1, 3, 16, 0.2f);
            });
            ((List)event.getTrades().get(5)).add((trader, rand) -> {
                Item egg = switch (rand.nextInt(7)) {
                    case 0 -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"spawn_egg_quarry_bee"));
                    case 1 -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"spawn_egg_rancher_bee"));
                    case 2 -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"spawn_egg_farmer_bee"));
                    case 3 -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"spawn_egg_cupid_bee"));
                    case 4 -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"spawn_egg_collector_bee"));
                    case 5 -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"spawn_egg_dye_bee"));
                    default -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"spawn_egg_lumber_bee"));
                };
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 24), Optional.empty(), new ItemStack((ItemLike)egg), 3, 12, 6, 0.2f);
            });
        }
    }

    @SubscribeEvent
    public static void entityRightClicked(PlayerInteractEvent.EntityInteract entityInteract) {
        Level level;
        ItemStack itemStack = entityInteract.getItemStack();
        Entity entity = entityInteract.getTarget();
        if (!itemStack.isEmpty() && entity instanceof Bee && (level = entityInteract.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Player player = entityInteract.getEntity();
            BlockPos pos = entity.blockPosition();
            Entity newBee = BeeHelper.itemInteract((Bee)entity, itemStack, serverLevel, player);
            if (newBee instanceof Bee) {
                level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 0.2, 0.1, 0.2);
                level.playSound(player, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BEEHIVE_WORK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.addFreshEntity(newBee);
                if (((Bee)entity).isLeashed()) {
                    ((Bee)entity).dropLeash(true, true);
                }
                entity.discard();
            }
        }
    }

    @SubscribeEvent
    public static void blockBreakSpawn(BlockEvent.BreakEvent event) {
        Player player;
        Level level;
        String beeType = "";
        int beeCount = 1;
        boolean angry = false;
        if (event.getState().getBlock().equals(Blocks.COCOA) && (Integer)event.getState().getValue((Property)CocoaBlock.AGE) == 2) {
            beeType = "productivebees:sugarbag";
        } else if (BuiltInRegistries.BLOCK.getKey((Object)event.getState().getBlock()).toString().equals("undergarden:gloomgourd")) {
            beeType = "productivebees:utheric";
            angry = true;
            beeCount = 3;
        }
        if (!beeType.isEmpty() && (level = (player = event.getPlayer()).level()) instanceof ServerLevel && player instanceof ServerPlayer && (double)level.random.nextFloat() < (Double)ProductiveBeesConfig.BEES.sugarbagBeeChance.get()) {
            for (int i = 0; i < beeCount; ++i) {
                ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).create(level);
                BlockPos pos = event.getPos();
                if (bee == null || BeeReloadListener.INSTANCE.getData(beeType) == null) continue;
                bee.setBeeType(beeType);
                bee.setDefaultAttributes();
                bee.moveTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, bee.getYRot(), bee.getXRot());
                level.addParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 0.2, 0.1, 0.2);
                level.playSound(player, pos, SoundEvents.BEEHIVE_WORK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.addFreshEntity((Entity)bee);
                if (!angry) continue;
                bee.setTarget((LivingEntity)player);
            }
        }
    }

    @SubscribeEvent
    public static void fuelValues(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().getItem();
        if (item.equals(ModItems.WAX.get())) {
            event.setBurnTime(100);
        } else if (item.equals(((Block)ModBlocks.WAX_BLOCK.get()).asItem())) {
            event.setBurnTime(900);
        }
    }

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        Level level;
        Player player = event.getEntity();
        if (!(player instanceof FakePlayer) && (level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = event.getHookEntity().blockPosition();
            Holder fishingBiome = player.level().getBiome(pos);
            ArrayList<BeeFishingRecipe> possibleRecipes = new ArrayList<BeeFishingRecipe>();
            List<BeeFishingRecipe> recipes = BeeFishingRecipe.getRecipeList((Holder<Biome>)fishingBiome, player.level());
            if (!recipes.isEmpty()) {
                for (BeeFishingRecipe recipe : recipes) {
                    boolean willSpawn = player.level().random.nextDouble() < (double)recipe.chance;
                    int fishingLuck = EnchantmentHelper.getFishingLuckBonus((ServerLevel)serverLevel, (ItemStack)player.getMainHandItem(), (Entity)player);
                    for (int i = 0; i < 1 + fishingLuck; ++i) {
                        willSpawn = willSpawn || player.level().random.nextDouble() < (double)recipe.chance;
                    }
                    if (!willSpawn) continue;
                    possibleRecipes.add(recipe);
                }
            }
            if (!possibleRecipes.isEmpty()) {
                BeeFishingRecipe chosenRecipe = (BeeFishingRecipe)possibleRecipes.get(player.level().random.nextInt(possibleRecipes.size()));
                BeeIngredient beeIngredient = chosenRecipe.output.get();
                Bee bee = (Bee)beeIngredient.getBeeEntity().create(player.level());
                if (bee != null) {
                    if (bee instanceof ConfigurableBee) {
                        ConfigurableBee configBee = (ConfigurableBee)bee;
                        configBee.setBeeType(beeIngredient.getBeeType().toString());
                        configBee.setDefaultAttributes();
                    }
                    bee.moveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, bee.getYRot(), bee.getXRot());
                    player.level().addParticle((ParticleOptions)ParticleTypes.POOF, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), 0.2, 0.1, 0.2);
                    player.level().playSound(player, pos, SoundEvents.BEE_HURT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    player.level().addFreshEntity((Entity)bee);
                    bee.setTarget((LivingEntity)player);
                    ((FishBeeTrigger)((Object)ModAdvancements.FISH_BEE.get())).trigger((ServerPlayer)player, bee);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Iterator<Entity> iter = JarBlockItemRenderer.beeEntities.values().iterator();
        while (iter.hasNext()) {
            Entity bee = iter.next();
            ++bee.tickCount;
            if (bee.tickCount % 6120 != 0) continue;
            iter.remove();
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Bee entity;
        Entity entity2;
        if (event.getLevel() instanceof ServerLevel && (entity2 = event.getEntity()) instanceof Bee && !(entity = (Bee)entity2).hasData(ProductiveBees.ATTRIBUTE_HANDLER)) {
            entity.getData(ProductiveBees.ATTRIBUTE_HANDLER);
        }
    }

    @SubscribeEvent
    public static void onBabyEntitySpawn(BabyEntitySpawnEvent event) {
        Bee bee;
        AgeableMob ageableMob = event.getChild();
        if (ageableMob instanceof Bee && (ageableMob = (bee = (Bee)ageableMob).level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)ageableMob;
            Mob mob = event.getParentA();
            if (mob instanceof Bee) {
                Bee parenA = (Bee)mob;
                mob = event.getParentB();
                if (mob instanceof AgeableMob) {
                    RecipeHolder<BeeBreedingRecipe> recipe;
                    AgeableMob parentB = (AgeableMob)mob;
                    if (!bee.hasData(ProductiveBees.ATTRIBUTE_HANDLER)) {
                        BeeHelper.setOffspringAttributes(bee, parenA, parentB);
                    }
                    if ((recipe = BeeHelper.getRandomBreedingRecipe(parenA, parentB, serverLevel)) != null) {
                        if (((BeeBreedingRecipe)recipe.value()).parentDeathChance > serverLevel.random.nextFloat()) {
                            parenA.setHasStung(true);
                        }
                        if (((BeeBreedingRecipe)recipe.value()).parentDeathChance > serverLevel.random.nextFloat() && parentB instanceof Bee) {
                            Bee parentBee = (Bee)parentB;
                            parentBee.setHasStung(true);
                        }
                    }
                }
            }
        }
    }
}

