/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.dispenser;

import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class CageDispenseBehavior
extends OptionalDispenseItemBehavior {
    private final DefaultDispenseItemBehavior fallbackDispenseBehavior = new DefaultDispenseItemBehavior();

    protected ItemStack execute(BlockSource pBlockSource, ItemStack stack) {
        if (stack.getItem() instanceof BeeCage && BeeCage.isFilled(stack)) {
            Direction direction = (Direction)pBlockSource.state().getValue((Property)DispenserBlock.FACING);
            Bee entity = BeeCage.getEntityFromStack(stack, (Level)pBlockSource.level(), true);
            if (entity != null) {
                entity.hivePos = null;
                BlockPos spawnPos = pBlockSource.pos().relative(direction);
                entity.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
                if (pBlockSource.level().addFreshEntity((Entity)entity)) {
                    if (stack.getItem().equals(ModItems.STURDY_BEE_CAGE.get()) && !pBlockSource.blockEntity().insertItem(new ItemStack((ItemLike)ModItems.STURDY_BEE_CAGE.get())).isEmpty()) {
                        Block.popResource((Level)pBlockSource.level(), (BlockPos)pBlockSource.pos().above(), (ItemStack)new ItemStack((ItemLike)ModItems.STURDY_BEE_CAGE.get()));
                    }
                    stack.shrink(1);
                }
                if (stack.getCount() > 0) {
                    return stack;
                }
            }
        }
        return this.fallbackDispenseBehavior.dispense(pBlockSource, stack);
    }
}

