/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen;

import cy.jdkdigital.productivebees.datagen.BeeProvider;
import cy.jdkdigital.productivebees.datagen.BlockLootProvider;
import cy.jdkdigital.productivebees.datagen.BlockTagProvider;
import cy.jdkdigital.productivebees.datagen.BlockstateProvider;
import cy.jdkdigital.productivebees.datagen.EntityTagProvider;
import cy.jdkdigital.productivebees.datagen.ItemTagProvider;
import cy.jdkdigital.productivebees.datagen.LootModifierProvider;
import cy.jdkdigital.productivebees.datagen.recipe.provider.RecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="productivebees", bus=EventBusSubscriber.Bus.MOD)
public class ProductiveBeeDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        gen.addProvider(event.includeServer(), (DataProvider)new BeeProvider(output));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockstateProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new BlockLootProvider(output, List.of(new LootTableProvider.SubProviderEntry(BlockLootProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
        gen.addProvider(event.includeServer(), (DataProvider)new LootModifierProvider(output, provider));
        BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, provider, blockTags.contentsGetter(), helper));
        gen.addProvider(event.includeServer(), (DataProvider)new EntityTagProvider(output, provider, helper));
    }
}

