/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.entity.CentrifugeBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class CentrifugeContainer
extends AbstractContainer {
    public final CentrifugeBlockEntity blockEntity;
    public final ContainerLevelAccess canInteractWithCallable;

    public CentrifugeContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CentrifugeContainer.getBlockEntity(playerInventory, data));
    }

    public CentrifugeContainer(int windowId, Inventory playerInventory, CentrifugeBlockEntity blockEntity) {
        this((MenuType)ModContainerTypes.CENTRIFUGE.get(), windowId, playerInventory, blockEntity);
    }

    public CentrifugeContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, final CentrifugeBlockEntity blockEntity) {
        super(type, windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        this.addDataSlots(new ContainerData(){

            public int get(int i) {
                return i == 0 ? blockEntity.fluidId : blockEntity.fluidHandler.getFluidInTank(0).getAmount();
            }

            public void set(int i, int value) {
                switch (i) {
                    case 0: {
                        blockEntity.fluidId = value;
                    }
                    case 1: {
                        FluidStack fluid = blockEntity.fluidHandler.getFluidInTank(0);
                        if (fluid.isEmpty()) {
                            blockEntity.fluidHandler.fill(new FluidStack((Fluid)BuiltInRegistries.FLUID.byId(blockEntity.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                            break;
                        }
                        fluid.setAmount(value);
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.recipeProgress;
            }

            public void set(int value) {
                blockEntity.recipeProgress = value;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, 1, 13, 35));
        this.addSlotBox((IItemHandler)this.blockEntity.inventoryHandler, InventoryHandlerHelper.OUTPUT_SLOTS[0], 67, 17, 3, 18, 3, 18);
        this.addSlotBox((IItemHandler)this.blockEntity.getUpgradeHandler(), 0, 165, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, 84);
    }

    private static CentrifugeBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof CentrifugeBlockEntity) {
            return (CentrifugeBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof Centrifuge && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

