/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.BreedingChamber;
import cy.jdkdigital.productivebees.common.block.entity.BreedingChamberBlockEntity;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.AbstractContainer;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;

public class BreedingChamberContainer
extends AbstractContainer {
    public final BreedingChamberBlockEntity blockEntity;
    public final ContainerLevelAccess canInteractWithCallable;
    public static final int SLOT_CAGE = 0;
    public static final int SLOT_BEE_1 = 1;
    public static final int SLOT_BEE_2 = 2;
    public static final int SLOT_BREED_ITEM_1 = 3;
    public static final int SLOT_BREED_ITEM_2 = 4;
    public static final int SLOT_OUTPUT = 5;

    public BreedingChamberContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, BreedingChamberContainer.getTileEntity(playerInventory, data));
    }

    public BreedingChamberContainer(int windowId, Inventory playerInventory, BreedingChamberBlockEntity blockEntity) {
        this((MenuType)ModContainerTypes.BREEDING_CHAMBER.get(), windowId, playerInventory, blockEntity);
    }

    public BreedingChamberContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, final BreedingChamberBlockEntity blockEntity) {
        super(type, windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.energyHandler.getEnergyStored();
            }

            public void set(int value) {
                if (blockEntity.energyHandler.getEnergyStored() > 0) {
                    blockEntity.energyHandler.extractEnergy(blockEntity.energyHandler.getEnergyStored(), false);
                }
                if (value > 0) {
                    blockEntity.energyHandler.receiveEnergy(value, false);
                }
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return blockEntity.recipeProgress;
            }

            public void set(int value) {
                blockEntity.recipeProgress = value;
            }
        });
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, 0, 121, 41));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, 1, 13, 17));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, 2, 49, 17));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, 3, 13, 37));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, 4, 49, 37));
        this.addSlot((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)this.blockEntity.inventoryHandler, 5, 139, 41));
        this.addSlotBox((IItemHandler)this.blockEntity.getUpgradeHandler(), 0, 165, 8, 1, 18, 4, 18);
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, 84);
    }

    private static BreedingChamberBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof BreedingChamberBlockEntity) {
            return (BreedingChamberBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.evaluate((world, pos) -> world.getBlockState(pos).getBlock() instanceof BreedingChamber && player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

