/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.jei;

import com.google.common.collect.Streams;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.recipe.BeeFloweringRecipe;
import cy.jdkdigital.productivebees.compat.jei.ProductiveBeesJeiPlugin;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class BeeFloweringRecipeCategory
implements IRecipeCategory<BeeFloweringRecipe> {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"bee_flowering");
    private final IDrawable icon;
    private final IDrawable background;

    public BeeFloweringRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/jei/bee_flowering_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 70, 82);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.POPPY));
    }

    public RecipeType<BeeFloweringRecipe> getRecipeType() {
        return ProductiveBeesJeiPlugin.BEE_FLOWERING_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.productivebees.bee_flowering");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BeeFloweringRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 29, 12).addIngredient(ProductiveBeesJeiPlugin.BEE_INGREDIENT, (Object)recipe.bee())).setSlotName("source");
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        List<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        try {
            List<Object> blockList = new ArrayList<Block>();
            if (recipe.blockTag() != null) {
                blockList = Streams.stream((Iterable)BuiltInRegistries.BLOCK.getTagOrEmpty(recipe.blockTag())).map(Holder::value).toList();
                if (blockList.isEmpty() && recipe.itemTag() != null) {
                    itemStacks.addAll(Streams.stream((Iterable)BuiltInRegistries.ITEM.getTagOrEmpty(recipe.itemTag())).map(itemHolder -> new ItemStack((ItemLike)itemHolder.value())).toList());
                }
            } else if (recipe.fluidTag() != null) {
                fluidStacks = Streams.stream((Iterable)BuiltInRegistries.FLUID.getTagOrEmpty(recipe.fluidTag())).map(fluidHolder -> new FluidStack((Fluid)fluidHolder.value(), 1000)).toList();
            } else if (recipe.block() != null) {
                blockList.add(recipe.block());
            } else if (recipe.fluid() != null) {
                fluidStacks.add(new FluidStack(recipe.fluid(), 1000));
            } else if (recipe.item() != null) {
                itemStacks.add(recipe.item());
            }
            for (Block block : blockList) {
                ItemStack item = new ItemStack((ItemLike)block.asItem());
                if (!item.getItem().equals(Items.AIR) && !itemStacks.contains(item)) {
                    itemStacks.add(item);
                    continue;
                }
                if (!(block instanceof CocoaBlock)) continue;
                itemStacks.add(new ItemStack((ItemLike)Items.COCOA_BEANS));
            }
        }
        catch (Exception e) {
            ProductiveBees.LOGGER.warn("Failed to find flowering requirements for " + String.valueOf(recipe));
        }
        if (!fluidStacks.isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 51).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStacks)).setSlotName("inputFluid");
        }
        if (!itemStacks.isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 26, 51).addItemStacks(itemStacks)).setSlotName("inputItem");
        }
    }
}

