/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.hwyla;

import cy.jdkdigital.productivebees.common.block.entity.SolitaryNestBlockEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class SolitaryNestProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"solitary_nest");
    static final SolitaryNestProvider INSTANCE = new SolitaryNestProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof SolitaryNestBlockEntity)) {
            return;
        }
        SolitaryNestBlockEntity tileEntity = (SolitaryNestBlockEntity)blockEntity;
        tileEntity.loadPacketNBT(accessor.getServerData(), (HolderLookup.Provider)accessor.getLevel().registryAccess());
        if (accessor.getServerData().contains("inhabitantName")) {
            tooltip.add((Component)Component.translatable((String)"productivebees.top.solitary.bee", (Object[])new Object[]{accessor.getServerData().getString("inhabitantName")}));
        } else {
            int cooldown = tileEntity.getNestTickCooldown();
            if (cooldown > 0) {
                tooltip.add((Component)Component.translatable((String)"productivebees.top.solitary.repopulation_countdown", (Object[])new Object[]{Math.round((float)cooldown / 20.0f) + "s"}));
            } else {
                tooltip.add((Component)Component.translatable((String)"productivebees.top.solitary.repopulation_countdown_inactive"));
                if (accessor.getServerData().getBoolean("canRepopulate")) {
                    tooltip.add((Component)Component.translatable((String)"productivebees.top.solitary.can_repopulate_true"));
                } else {
                    tooltip.add((Component)Component.translatable((String)"productivebees.top.solitary.can_repopulate_false"));
                }
            }
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor blockAccessor) {
        tag.getAllKeys().clear();
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof SolitaryNestBlockEntity) {
            SolitaryNestBlockEntity nest = (SolitaryNestBlockEntity)blockEntity;
            nest.savePacketNBT(tag, (HolderLookup.Provider)blockAccessor.getLevel().registryAccess());
            tag.putBoolean("canRepopulate", nest.canRepopulate());
            if (!nest.isEmpty()) {
                EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)((BeehiveBlockEntity.BeeData)nest.stored.get((int)0)).occupant.entityData().getUnsafe().getString("id")));
                tag.putString("inhabitantName", Component.translatable((String)type.getDescriptionId()).getString());
            }
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

