/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.compat.emi;

import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.compat.emi.BeeEmiStack;
import cy.jdkdigital.productivebees.compat.emi.ProductiveBeesEmiPlugin;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.Tags;

public class BeeFishingEmiRecipe
extends BasicEmiRecipe {
    private final HolderSet<Biome> biomes;
    ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/jei/bee_fishing_recipe.png");

    public BeeFishingEmiRecipe(RecipeHolder<BeeFishingRecipe> recipe) {
        super(ProductiveBeesEmiPlugin.BEE_FISHING_CATEGORY, recipe.id(), 126, 110);
        this.inputs.add(EmiIngredient.of((TagKey)Tags.Items.TOOLS_FISHING_ROD));
        this.outputs.add(BeeEmiStack.of(((BeeFishingRecipe)recipe.value()).output.get()));
        this.biomes = ((BeeFishingRecipe)recipe.value()).biomes;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(this.location, 0, 0, 126, 110, 0, 0);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 92, 16).drawBack(false);
        int xPos = 0;
        AtomicInteger yPos = new AtomicInteger(45);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level != null) {
            Registry biomeRegistry = minecraft.level.registryAccess().registryOrThrow(Registries.BIOME);
            for (Holder biome : this.biomes) {
                ResourceLocation key = biomeRegistry.getKey((Object)((Biome)biome.value()));
                if (key == null) continue;
                widgets.addText((Component)Component.translatable((String)("biome.minecraft." + key.getPath())), xPos, yPos.get(), -16777216, false);
                Objects.requireNonNull(minecraft.font);
                yPos.addAndGet(9 + 2);
            }
        }
    }
}

