/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public class SpawnEgg
extends DeferredSpawnEggItem {
    public SpawnEgg(Supplier<EntityType<? extends Mob>> entityType, int primaryColor, int secondaryColor, Item.Properties properties) {
        super(entityType, primaryColor, secondaryColor, properties);
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player pPlayer, Mob pMob, EntityType<? extends Mob> pEntityType, ServerLevel pServerLevel, Vec3 pPos, ItemStack pStack) {
        Object t;
        Optional result = super.spawnOffspringFromSpawnEgg(pPlayer, pMob, pEntityType, pServerLevel, pPos, pStack);
        if (result.isPresent() && pStack.has(ModDataComponents.BEE_TYPE) && (t = result.get()) instanceof ConfigurableBee) {
            ConfigurableBee cBee = (ConfigurableBee)t;
            cBee.setBeeType(((ResourceLocation)pStack.get(ModDataComponents.BEE_TYPE)).toString());
            return Optional.of(cBee);
        }
        return result;
    }

    public int getColor(int tintIndex, ItemStack stack) {
        CompoundTag nbt;
        CustomData data = (CustomData)stack.get(DataComponents.ENTITY_DATA);
        if (data != null && (nbt = BeeReloadListener.INSTANCE.getData(ResourceLocation.parse((String)data.getUnsafe().getString("type")))) != null) {
            return tintIndex == 0 ? nbt.getInt("primaryColor") : nbt.getInt("secondaryColor");
        }
        return super.getColor(tintIndex);
    }

    @Nonnull
    public Component getName(ItemStack stack) {
        ResourceLocation beeType;
        CompoundTag nbt;
        CustomData data = (CustomData)stack.get(DataComponents.ENTITY_DATA);
        if (data != null && (nbt = BeeReloadListener.INSTANCE.getData(beeType = ResourceLocation.parse((String)data.getUnsafe().getString("type")))) != null) {
            String name = Component.translatable((String)("entity.productivebees." + ProductiveBee.getBeeName(beeType) + "_bee")).getString();
            return Component.translatable((String)"item.productivebees.spawn_egg_configurable", (Object[])new Object[]{name});
        }
        return super.getName(stack);
    }
}

