/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.fluid;

import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;

public abstract class HoneyFluid
extends BaseFlowingFluid {
    public static final ResourceLocation STILL = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"block/honey/still");
    public static final ResourceLocation FLOWING = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"block/honey/flow");
    public static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"block/honey/overlay");

    protected HoneyFluid() {
        super(new BaseFlowingFluid.Properties(ModFluids.HONEY_FLUID_TYPE, ModFluids.HONEY, ModFluids.HONEY_FLOWING).bucket(ModItems.HONEY_BUCKET).block(ModBlocks.HONEY));
    }

    public Fluid getFlowing() {
        return (Fluid)ModFluids.HONEY_FLOWING.get();
    }

    public Fluid getSource() {
        return (Fluid)ModFluids.HONEY.get();
    }

    public void animateTick(Level worldIn, BlockPos pos, FluidState state, RandomSource random) {
        BlockPos blockpos = pos.above();
        if (random.nextInt(100) == 0 && !worldIn.getBlockState(blockpos).getFluidState().equals(state)) {
            worldIn.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HONEY_BLOCK_SLIDE, SoundSource.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_HONEY;
    }

    public int getSlopeFindDistance(LevelReader worldIn) {
        return worldIn.dimensionType().ultraWarm() ? 6 : 3;
    }

    public boolean isSame(Fluid fluidIn) {
        return fluidIn.is(ModTags.HONEY);
    }

    public int getDropOff(LevelReader worldIn) {
        return worldIn.dimensionType().ultraWarm() ? 1 : 2;
    }

    public int getTickDelay(LevelReader worldIn) {
        return worldIn.dimensionType().ultraWarm() ? 10 : 30;
    }

    public int getSpreadDelay(Level world, BlockPos pos, FluidState state, FluidState FluidState2) {
        int i = this.getTickDelay((LevelReader)world);
        if (!(state.isEmpty() || FluidState2.isEmpty() || ((Boolean)state.getValue((Property)FALLING)).booleanValue() || ((Boolean)FluidState2.getValue((Property)FALLING)).booleanValue() || !(FluidState2.getHeight((BlockGetter)world, pos) > state.getHeight((BlockGetter)world, pos)) || world.getRandom().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    public static class Source
    extends HoneyFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends HoneyFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }
}

