/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee;

import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class GeckoBee
extends ConfigurableBee
implements GeoEntity {
    protected static final RawAnimation BEE_FLY = RawAnimation.begin().thenLoop("animation.bee.fly");
    protected static final RawAnimation BEE_ATTACK = RawAnimation.begin().thenPlay("animation.bee.attack");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GeckoBee(EntityType<? extends Bee> entityType, Level world) {
        super(entityType, world);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "animation", 0, state -> {
            if (this.swinging && !this.hasStung()) {
                state.setAndContinue(BEE_ATTACK);
                return PlayState.STOP;
            }
            return state.setAndContinue(BEE_FLY);
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public ResourceLocation getModelLocation() {
        CompoundTag data = this.getNBTData();
        return data.contains("model") ? ResourceLocation.parse((String)data.getString("model")) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)("geo/entity/" + (this.getRenderer().isEmpty() ? "default" : this.getRenderer()) + ".geo.json"));
    }

    public ResourceLocation getTextureLocation() {
        Object textureLocation = "productivebees:textures/entity/bee/" + this.getBeeName() + "/bee";
        if (this.isColored()) {
            String modelType = this.getRenderer();
            textureLocation = "productivebees:textures/entity/bee/base/" + (!modelType.isEmpty() ? modelType : "default") + "/bee";
        }
        if (this.hasBeeTexture()) {
            textureLocation = this.getBeeTexture();
        }
        if (this.isAngry()) {
            textureLocation = (String)textureLocation + "_angry";
        }
        if (this.hasNectar()) {
            textureLocation = (String)textureLocation + "_nectar";
        }
        return ResourceLocation.parse((String)((String)textureLocation + ".png"));
    }

    public ResourceLocation getAnimationLocation() {
        CompoundTag data = this.getNBTData();
        return data.contains("animation") ? ResourceLocation.parse((String)data.getString("animation")) : ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"animations/entity/bee.animation.json");
    }
}

