/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class JarBlockEntity
extends CapabilityBlockEntity {
    @Nullable
    private Entity cachedEntity;
    public int tickCount = 0;
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 1, (BlockEntity)this){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getItem().asItem() instanceof BeeCage && BeeCage.isFilled(stack);
        }

        public boolean isContainerItem(Item item) {
            return item instanceof BeeCage;
        }

        public boolean isInputSlot(int slot) {
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            Level level = this.blockEntity.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 3);
            }
        }
    };

    public JarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.JAR.get(), pos, state);
    }

    @Nullable
    public Entity getCachedEntity(ItemStack cage) {
        if (this.cachedEntity == null) {
            this.cachedEntity = BeeCage.getEntityFromStack(cage, this.getLevel(), false);
        }
        return this.cachedEntity;
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.tickCount = ProductiveBees.random.nextInt(360);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        ((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(items);
        if (!items.isEmpty() && !((ItemStack)items.getFirst()).isEmpty()) {
            this.getItemHandler().insertItem(0, (ItemStack)items.getFirst(), false);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        IItemHandlerModifiable iItemHandlerModifiable = this.inventoryHandler;
        if (iItemHandlerModifiable instanceof ItemStackHandler) {
            ItemStackHandler serializable = (ItemStackHandler)iItemHandlerModifiable;
            if (this.level != null) {
                components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(List.of(this.getItemHandler().getStackInSlot(0))));
            }
        }
    }
}

