/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivelib.common.block.entity.AbstractBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CombBlockBlockEntity
extends AbstractBlockEntity {
    private ResourceLocation combType;

    public CombBlockBlockEntity(BlockPos pos, BlockState state) {
        this(null, pos, state);
    }

    public CombBlockBlockEntity(ResourceLocation combType, BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.COMB_BLOCK.get(), pos, state);
        this.combType = combType;
    }

    public void setCombType(ResourceLocation combType) {
        this.combType = combType;
    }

    public ResourceLocation getCombType() {
        return this.combType;
    }

    public int getColor() {
        CompoundTag nbt;
        if (this.combType != null && (nbt = BeeReloadListener.INSTANCE.getData(this.combType)) != null) {
            return nbt.getInt("primaryColor");
        }
        return 0;
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.combType != null) {
            tag.putString("type", this.combType.toString());
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("type")) {
            this.setCombType(ResourceLocation.parse((String)tag.getString("type")));
        }
    }
}

