/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.block.Bottler;
import cy.jdkdigital.productivebees.common.item.GeneBottle;
import cy.jdkdigital.productivebees.common.recipe.BottlerRecipe;
import cy.jdkdigital.productivebees.container.BottlerContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivelib.common.block.entity.FluidTankBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BottlerBlockEntity
extends FluidTankBlockEntity
implements MenuProvider {
    protected int tickCounter = 0;
    public int fluidId = 0;
    public IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 12, (BlockEntity)this){

        public boolean isContainerItem(Item item) {
            return item == Items.GLASS_BOTTLE || item == Items.BUCKET || item == Items.HONEYCOMB;
        }
    };
    public FluidTank fluidHandler = new FluidTank(10000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            BottlerBlockEntity.this.fluidId = BuiltInRegistries.FLUID.getId((Object)this.getFluid().getFluid());
            BottlerBlockEntity.this.updateBottleState();
        }
    };

    private void updateBottleState() {
        if (this.level != null) {
            boolean hasBottle;
            ItemStack stack = this.inventoryHandler.getStackInSlot(0);
            boolean bl = hasBottle = !stack.isEmpty() && stack.getItem().equals(Items.GLASS_BOTTLE);
            if (hasBottle != (Boolean)this.getBlockState().getValue((Property)Bottler.HAS_BOTTLE)) {
                this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)Bottler.HAS_BOTTLE, (Comparable)Boolean.valueOf(hasBottle)), 3);
            }
        }
    }

    public BottlerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BOTTLER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BottlerBlockEntity blockEntity) {
        List<Bee> bees;
        BlockState aboveState = level.getBlockState(pos.above());
        if (++blockEntity.tickCounter % 7 == 0 && aboveState.getBlock() == Blocks.PISTON_HEAD && aboveState.getValue((Property)DirectionalBlock.FACING) == Direction.DOWN && !(bees = level.getEntitiesOfClass(Bee.class, new AABB(pos).expandTowards(0.0, 1.0, 0.0)).stream().filter(e -> !e.isBaby()).toList()).isEmpty()) {
            Bee bee = bees.iterator().next();
            ItemStack bottles = blockEntity.inventoryHandler.getStackInSlot(0);
            if (!bottles.isEmpty() && bottles.getItem().equals(Items.GLASS_BOTTLE) && !bee.isBaby() && bee.isAlive()) {
                ItemStack geneBottle = GeneBottle.getStack((Entity)bee);
                Block.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)geneBottle);
                level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                bee.kill();
                bottles.shrink(1);
            }
        }
        FluidTankBlockEntity.tick((Level)level, (BlockPos)pos, (BlockState)state, (FluidTankBlockEntity)blockEntity);
    }

    public void tickFluidTank(Level level, BlockPos pos, BlockState state, FluidTankBlockEntity blockEntity) {
        BottlerBlockEntity bottlerBlockEntity;
        IItemHandler invHandler;
        FluidStack fluidStack = blockEntity.getFluidHandler().getFluidInTank(0);
        if (fluidStack.getAmount() >= 0 && level instanceof ServerLevel && blockEntity instanceof BottlerBlockEntity && (invHandler = (bottlerBlockEntity = (BottlerBlockEntity)blockEntity).getItemHandler()) instanceof ItemStackHandler) {
            ItemStack fluidContainerItem = invHandler.getStackInSlot(0);
            ItemStack existingOutput = invHandler.getStackInSlot(11);
            if (fluidContainerItem.getCount() > 0 && (existingOutput.isEmpty() || existingOutput.getCount() < existingOutput.getMaxStackSize())) {
                ArrayList<BottlerRecipe> recipes = new ArrayList<BottlerRecipe>();
                List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.BOTTLER_TYPE.get());
                for (RecipeHolder entry : allRecipes) {
                    BottlerRecipe recipe = (BottlerRecipe)entry.value();
                    if (!recipe.matches(fluidStack, fluidContainerItem)) continue;
                    recipes.add(recipe);
                }
                if (recipes.size() > 0) {
                    recipe = (BottlerRecipe)recipes.iterator().next();
                    if (existingOutput.isEmpty() || existingOutput.getItem().equals(((BottlerRecipe)recipe).getResultItem((HolderLookup.Provider)level.registryAccess()).getItem())) {
                        BottlerBlockEntity.processOutput((IFluidHandler)this.fluidHandler, invHandler, ((BottlerRecipe)recipe).getResultItem((HolderLookup.Provider)level.registryAccess()).copy(), ((BottlerRecipe)recipe).fluidInput.amount(), true);
                    }
                } else {
                    recipe = fluidContainerItem.getCapability(Capabilities.FluidHandler.ITEM);
                    if (recipe instanceof IFluidHandlerItem) {
                        IFluidHandlerItem itemFluidHandler = (IFluidHandlerItem)recipe;
                        int amount = itemFluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                        BottlerBlockEntity.processOutput((IFluidHandler)this.fluidHandler, invHandler, (ItemStack)(itemFluidHandler.getFluidInTank(0).getAmount() == itemFluidHandler.getTankCapacity(0) ? fluidContainerItem : null), amount, false);
                    } else {
                        FluidActionResult fillResult = FluidUtil.tryFillContainer((ItemStack)fluidContainerItem, (IFluidHandler)this.fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true);
                        if (fillResult.isSuccess()) {
                            BottlerBlockEntity.processOutput((IFluidHandler)this.fluidHandler, invHandler, fillResult.getResult(), 0, true);
                        }
                    }
                }
            }
        }
    }

    private static void processOutput(IFluidHandler fluidHandler, IItemHandler itemHandler, ItemStack outputItem, int drainedAmount, boolean shrinkInputStack) {
        if (shrinkInputStack) {
            itemHandler.getStackInSlot(0).shrink(1);
        }
        if (outputItem != null) {
            itemHandler.insertItem(11, outputItem, false);
        }
        fluidHandler.drain(drainedAmount, IFluidHandler.FluidAction.EXECUTE);
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        Fluid fluid = this.fluidHandler.getFluidInTank(0).getFluid();
        this.fluidId = BuiltInRegistries.FLUID.getId((Object)fluid);
    }

    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.BOTTLER.get()).getDescriptionId());
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new BottlerContainer(pContainerId, pPlayerInventory, this);
    }
}

